document.addEventListener('DOMContentLoaded', function () {
    const dominioServidorAcade = document.getElementById('dominioServidorAcade');
    const saveButton = document.getElementById('saveButton');
    const ativarBotao = document.getElementById('flexSwitchCheckChecked');
    const labelAtivado = document.getElementById('labelAtivado');

    // Recuperar a mensagem salva do armazenamento local ao carregar o popup
    chrome.storage.local.get('dominioServidorAcade', function (result) {
        if (result.dominioServidorAcade) {
            console.log(`servidor ${result.dominioServidorAcade}`);
            dominioServidorAcade.value = result.dominioServidorAcade; // Preencher o input com a mensagem salva
        }
    });
    chrome.storage.local.get('servicoAcade', function (result) {
        if(result.servicoAcade=="1"){
            labelAtivado.innerText="Ativado";
            ativarBotao.checked = 1;
        }
        else{
            labelAtivado.innerText="Desativado";
            ativarBotao.checked = 0;
        }
    });
    // Salvar a mensagem no armazenamento local ao clicar no botão "Salvar"
    saveButton.addEventListener('click', function () {
        const dominio = dominioServidorAcade.value;
        chrome.storage.local.set({ dominioServidorAcade: dominio }, function () {
            alert('Domínio salvo com sucesso!');
        });
    });
    ativarBotao.addEventListener('change', function () {
        const valor = ativarBotao.checked;
        console.log(valor)
        if(ativarBotao.checked){
            labelAtivado.innerText="Ativado";
        }
        else{
            labelAtivado.innerText="Desativado";
        }
        chrome.storage.local.set({ servicoAcade: ativarBotao.checked?"1":"0" }, function () {
            console.log(ativarBotao.checked?"Serviço ativado":"Serviço desativado");
        });
    });
});