from selenium import webdriver
from selenium.webdriver.common.by import By
from selenium.webdriver.common.keys import Keys
from selenium.webdriver.support.ui import WebDriverWait
from selenium.webdriver.support import expected_conditions as EC
from selenium.common.exceptions import NoSuchElementException, TimeoutException
from selenium.webdriver.chrome.service import Service
from selenium.webdriver.chrome.options import Options

# Configurar opções do Chrome
chrome_options = Options()
chrome_options.add_argument("--ignore-certificate-errors")
chrome_options.add_argument("--disable-web-security")
import time
import os
import pickle
import requests
import random
print("Automatização de whatsapp versão 0.1")
dominio = "testdrive"
print("Conectando no lotear "+dominio)
tempo_min = 0.01
tempo_max = 0.1
headers = {
    "User-Agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36"
}
def login_whatsapp(driver):
    driver.get('https://web.whatsapp.com')
    
    # Espera o usuário escanear o QR Code
    print("Por favor, escaneie o QR Code com seu aplicativo WhatsApp para continuar.")
    time.sleep(30)  # Ajuste o tempo conforme necessário
    

def digitar_com_delay(elemento, texto, delay_min=0.1, delay_max=0.3):
    for caractere in texto:
        if caractere == '\n':
            elemento.send_keys(Keys.SHIFT, Keys.ENTER)
        elif caractere == '\r':
            continue
        else:
            elemento.send_keys(caractere)
        
        time.sleep(random.uniform(delay_min, delay_max))

def iniciar_conversa(driver, numero_telefone, mensagem,id):
    print(id)
    try:
        # Localiza e clica no elemento "Nova conversa"
        nova_conversa = driver.find_element(By.XPATH, '//div[@data-tab="2" and @title="Nova conversa"]')
        nova_conversa.click()
        time.sleep(2)  # Aguarda um pouco para a interface de nova conversa aparecer

        # Digita o número de telefone na barra de pesquisa com delay
        search_box = driver.find_element(By.XPATH, '//div[@data-tab="3"]')
        digitar_com_delay(search_box, numero_telefone,tempo_min, tempo_max)
        time.sleep(10)  # Aguarda um pouco para o número ser processado
        
        # Verifica se a pesquisa retornou algum resultado
        resultado_pesquisa = driver.find_element(By.XPATH, '//div[@tabindex="-1"]')
        # Clica no resultado da pesquisa para abrir a conversa
        search_box.send_keys(Keys.ENTER)
        time.sleep(2)  # Aguarda a interface da conversa carregar

        # Localiza a caixa de mensagem usando label="Digite uma mensagem" e data-tab="10"
        message_box = driver.find_element(By.XPATH, '//div[@data-tab="10" and (@aria-label="Digite uma mensagem" or @aria-placeholder="Digite uma mensagem")]')
        
        # Digita a mensagem na caixa de entrada com delay
        digitar_com_delay(message_box, mensagem,tempo_min, tempo_max)
        
        # Localiza o botão de enviar mensagem e clica nele
        send_button = driver.find_element(By.XPATH, '//button[@data-tab="11"]')
        send_button.click()
        
        print(f"Mensagem enviada para {numero_telefone}!")

        # Clica na div com role="button" tabindex="0" data-tab="6" title="Mais opções"
        mais_opcoes = driver.find_element(By.XPATH, '//div[@role="button" and @tabindex="0" and @data-tab="6" and @title="Mais opções"]')
        mais_opcoes.click()
        time.sleep(1)  # Aguarda um pouco para a interface de opções aparecer

        # Clica na div com role="button" aria-label="Fechar conversa"
        fechar_conversa = driver.find_element(By.XPATH, '//div[@role="button" and @aria-label="Fechar conversa"]')
        fechar_conversa.click()
        print("Conversa fechada.")
        url = "https://"+dominio+".acadeone.com.br/acadelotear/?m=sc&c=cliente&a=eventoWhatsapp"
        data = {
            'ack': 1,
            'agendamento': id
        }

        response = requests.post(url, data=data,headers=headers)

        if response.status_code == 200:
            print("Sucesso ao enviar agendamento!")
        else:
            print("Falha ao alterar o agendamento!")
            print("Código de status:", response.status_code)
            print("Resposta:", response.text)

    except Exception as e:
        print(f"Erro ao enviar a mensagem para {numero_telefone}")
        driver.refresh()
        url = "https://"+dominio+".acadeone.com.br/acadelotear/?m=sc&c=cliente&a=eventoWhatsapp"
        data = {
            'ack': -1,
            'agendamento': id
        }

        response = requests.post(url, data=data,headers=headers)

        if response.status_code == 200:
            print("Falha ao enviar agendamento!")
        else:
            print("Falha ao alterar o agendamento!")
            print("Código de status:", response.status_code)
            print("Resposta:", response.text)
        
        time.sleep(120)
        return

def main():
    # Configura o WebDriver para o Chrome
    chrome_options.add_experimental_option('excludeSwitches', ['enable-logging'])
    driver = webdriver.Chrome( options=chrome_options)
    
    login_whatsapp(driver)
    
    while True:
        try:
            
            if driver.find_elements(By.XPATH, '//div[contains(text(), "Use o WhatsApp no seu computador")]'):
                print("Você ainda está na tela de login. Por favor, escaneie o QR Code.")
                time.sleep(120)
            else:
                # Fazendo a solicitação GET
                response = requests.get("https://"+dominio+".acadeone.com.br/acadelotear/?m=comunicacao&c=agendamento&a=whatsAppPendente",headers=headers)

                # Verificando se a solicitação foi bem-sucedida
                if response.status_code == 200:
                    # Acessando o conteúdo da resposta
                    data = response.json()  # Se a resposta for JSON
                    #title = data.get('id', 'Título não encontrado')  # Utiliza get() para evitar erro se a chave não existir
                    #print(data[0])
                    for agendamento in data:
                        print("------------------")
                        print("Enviando mensagem para "+agendamento.get('nomeDestinatario')+" - "+agendamento.get('emailDestinatario'))
                        iniciar_conversa(driver, "55"+agendamento.get('emailDestinatario'), agendamento.get('conteudo'),agendamento.get('id'))
                else:
                    print(f"Erro ao fazer a solicitação: {response.status_code}")
                
                time.sleep(10) 

                # Recebe o número de telefone e a mensagem do terminal
                #numero_telefone = input("Digite o número de telefone (com código do país, ex: 5583986302767) ou 'sair' para encerrar: ")
                
                # Verifica se o usuário deseja sair
                #if numero_telefone.lower() == 'sair':
                #    break
                
                #mensagem = input("Digite a mensagem para enviar: ")
                
                # Inicia a conversa e envia a mensagem
                #iniciar_conversa(driver, numero_telefone, mensagem)
        except Exception as e:
            print(f"Falha na requisição ao servidor")
    
    # Fecha o navegador
    driver.quit()

if __name__ == "__main__":
    main()