<?php
    require_once '../../config/config.php';

    $payload = @file_get_contents('php://input');
    $event = json_decode($payload, true);
    
    if ($event['data']['status'] == "paid") {
        // $data = openssl_x509_parse(file_get_contents('../../webhooks/webhook_grafeno/chave_publica_api_grafeno.pem'));
        
        $multa = 0;
        $juros = 0;
    
        $banco = (new Banco())->getBanco(6);
    
        if (strtotime($event['data']['dueDate']) < strtotime($event['data']['payments'][0]['receivedAt'])) {
            $diasAtraso = abs(strtotime($event['data']['dueDate']) - strtotime($event['data']['payments'][0]['receivedAt']));
            $diasAtraso = round($diasAtraso / (60 * 60 * 24));
            
            if ($diasAtraso < 0)
                $diasAtraso = 0;
            
            $multa = (($event['data']['applicableFine'] / 100) * $event['data']['value']) * 100;
            $juros = (($banco['juros'] / 100) * $event['data']['value']) * $diasAtraso;
            //Evita que o valor seja arredondado
            $multa = number_format(floor($multa*100)/100, 2);
            $juros = number_format(floor($juros*100)/100, 2);
        }
    
        RetornoBoleto::atualizarParcelaApiIdParcelaContratoBancoGrafeno(
            $event['data']['clientControlNumber'],
            null,
            $event['data']['payments'][0]['receivedAt'],
            $multa,
            $juros,
            $event['data']['discountValue'],
            0,
            $event['data']['payments'][0]['value'],
            6
        );
    }
    
    // file_put_contents('../../input.txt', $payload);

    /**
     * ------- PADRO DOS DADOS RETORNADOS PELO WEBHOOK ---------
     * 
     * $event['signature'];
     * $event['change'];
     * $event['data']['abatementValue'];
     * $event['data']['applicableFine'];
     * $event['data']['boleto']['barCode'];
     * $event['data']['boleto']['lineCode'];
     * $event['data']['boleto']['ourNumber'];
     * $event['data']['boleto']['ourNumberDv'];
     * $event['data']['boleto']['pdf'];
     * $event['data']['boleto']['quickPdfUrl'];
     * $event['data']['boleto']['registrationMethod'];
     * $event['data']['boleto']['registrationStatus'];
     * $event['data']['boleto']['yourNumber'];
     * $event['data']['boleto']['emv'];
     * $event['data']['boleto']['image'];
     * $event['data']['clientControlNumber'];
     * $event['data']['createdAt'];
     * $event['data']['daysWriteOffAfterDueDate'];
     * $event['data']['discountType'];
     * $event['data']['discountValue'];
     * $event['data']['dueDate'];
     * $event['data']['interestType'];
     * $event['data']['monthlyInterest'];
     * $event['data']['origin'];
     * $event['data']['payer']['address']['city'];
     * $event['data']['payer']['address']['complement'];
     * $event['data']['payer']['address']['neighborhood'];
     * $event['data']['payer']['address']['number'];
     * $event['data']['payer']['address']['state'];
     * $event['data']['payer']['address']['street'];
     * $event['data']['payer']['address']['zipCode'];
     * $event['data']['payer']['documentNumber'];
     * $event['data']['payer']['email'];
     * $event['data']['payer']['name'];
     * $event['data']['payer']['phone'];
     * $event['data']['paymentMethod'];
     * $event['data']['status'];
     * $event['data']['uuid'];
     * $event['data']['value'];
     * $event['data']['payments'][0]['value'];
     * $event['data']['payments'][0]['receivedAt'];
     * $event['data']['payments'][0]['processedAt'];
     * $event['data']['payments'][0]['paymentBankCode'];
     * $event['data']['payments'][0]['paymentAgency'];
     */
?>