$(document).ready(function () {
    var url = window.location.href.split('=');
    if (url[3] == "editar&id" && jQuery.trim($('#perfil').find('option:selected').text()) == "Imobiliria") {
        $('.rowImobiliaria').show();
    }

    $("#pessoas").autocomplete({
        source: "index.php?m=lo&c=ajax&a=find_pessoa",
        select: function (event, ui) {
            if (ui.item) {
                var pessoa = ui.item,
                    value = pessoa.value,
                    id = pessoa.id;

                $('#pessoas').val(value);
                $('#pessoa').val(id);
            }
            return false;
        }
    }).on('blur', function () {
        if ($(this).val() == '') {
            $('#pessoas').attr('value', '');
            $('#pessoa').attr('value', '');
        }
    });

    select2RemoteData(
        '#idCliente', //Id
        false, //Multiplo
        true, //Disabled
        'Digite o nome, cpf ou cnpj do Cliente',
        '?m=sc&c=ajax&a=findPessoasByNome'
    );

    select2RemoteData(
        '#empreendimento', //Id
        true, //Multiplo
        true, //Disabled
        'Digite o nome do Empreendimento',
        '?m=sc&c=ajax&a=findEmpreendimentoByNome'
    );
});

//Funo para change do select2 funcionar mais tranquilamente
function selectChange(select) {
    if (select.hasClass('empreendimento_contrato')) {
        $("select.lotes").html('<option value="">Selecione ...</option>');
        $("select.bancos").html('<option value="">Selecione ...</option>');
        $("select.corretores").html('<option value="">Selecione ...</option>');
        $.ajax({
            type: "POST",
            url: "index.php?m=adm&c=contrato&a=loteClienteByEmpreendimento",
            data: "id_empreendimento=" + select.val(),
            success: function (response) {
                $("select.lotes").select2({
                    'data': JSON.parse(response),
                    'placeholder': 'Escolha o Lote',
                    'allowClear': false
                });
            }
        });
        $.ajax({
            type: "POST",
            url: "index.php?m=adm&c=contrato&a=bancoByEmpreendimento",
            data: "id_empreendimento=" + select.val(),
            success: function (response) {
                $("select.bancos").select2({
                    'data': JSON.parse(response),
                    'placeholder': 'Escolha o Banco',
                    'allowClear': false
                });
            }
        });
        $.ajax({
            type: "POST",
            url: "index.php?m=adm&c=contrato&a=corretorByEmpreendimento",
            data: "id_empreendimento=" + select.val(),
            success: function (response) {
                $("select.corretores").select2({
                    'data': JSON.parse(response),
                    'placeholder': 'Escolha o Corretor',
                    'allowClear': false
                });
            }
        });
    }
    
    if (select.hasClass('perfil_imobiliaria')) {
        $("select.imobiliaria").html('<option value=""></option>');
        
        if (jQuery.trim(select.find('option:selected').text()) == "Imobiliria") {
            $('.rowImobiliaria').show();
            $.ajax( {
                type: "POST",
                url: "index.php?m=adm&c=ajax&a=buscaTodasAsPessoasJuridicas",
                success: function (response) {
                    $("select.imobiliaria").select2({
                        'data': JSON.parse(response),
                        'placeholder': 'Selecione a imobiliaria',   
                        'allowClear': true
                    });
                } 
            });
        } else {
            $('.rowImobiliaria').hide();
        }
    }
}