$(document).ready(function () {
    carregaDados();
});
function selectChange(select) {
    if (select.hasClass('tabelaAgrupada')) {
        carregaDados();
    }
}
/**
 * Listar
 *
 */
//Carregas os lotes ao selecionar uma quadra
function carregaDados() {
    var dTbVizualizar = $('#TabelaListar').DataTable();
    //se a tabela j tiver sido inicializada, recarrega ajax
    dTbVizualizar.destroy();

    $('#TabelaListar').DataTable({
        "processing": true,
        "serverSide": true,
        "autoWidth": true,
        "ajax": $('#TabelaListar').dataTable.pipeline({
            "url": "?m=&c=tabelaAgrupada&a=listaByAgrupada",
            "pages": 5,
            'data': function (data) {
                data.agrupadas = $("#tabelaAgrupada").val();
            }
        }),
        "columns": [
            {"data": 'tabela'},
            {"data": 'descricao'},
            {"data": 'complemento'},
            {"data": 'fixo'},
            {"data": 'acoes'}
        ],

        //Define a coluna default que ser ordenada quando abrir a pgina
        "order": [[0, "desc"]],

        //Organiza os botoes, paginao, campos e notificaes
        dom: '<"btnAdicionar">lfrtip',

        //Define as opes de quantidade de linhas que apareco na lista
        "lengthMenu": [[10, 25, 50], [10, 25, 50]],

        //Define as colunas que no tero ordenao
        "columnDefs": [
            {
                "orderable": false,
                "targets": -1,
                "searchable": false
            }
        ],

        //Pensonalizando as mensagens que por default so em ingls e formatao de valores
        language: {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "",
            "sInfoEmpty": "",
            "sInfoFiltered": "",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Busca",
            "oPaginate": {
                "sNext": "Prximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "ltimo"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            },
            "decimal": ",",
            "thousands": "."
        }
    });
    var btnAdicionar = '<a class="btn btn-success" href="?m=&c=tabelaAgrupada&a=adicionar"><i class="fa fa-plus-circle"></i> Adicionar</a>';
    $("div.btnAdicionar").html(btnAdicionar);
}
function inativar(idCampo) {
    $.ajax({
        type: "POST",
        url: "?m=&c=tabelaAgrupada&a=inativar",
        data: "idCampo="+idCampo+"&idTabela="+$('#tabelaAgrupada').val(),
        success: function (response) {
            var json = JSON.parse(response);
            if (json == '1') {
                $('#status_'+idCampo).html('<span class="label label-success">Ativo</span>');
                $('#icon_'+idCampo).attr('class','fa fa-lock');
                $('#button_'+idCampo).attr('data-original-title','INATIVAR');
            } else  {
                $('#status_'+idCampo).html('<span class="label label-danger">Inativo</span>');
                $('#icon_'+idCampo).attr('class','fa fa-unlock-alt');
                $('#button_'+idCampo).attr('data-original-title','ATIVAR');
            }
        }
    });
}
