$(document).ready(function () {
    /**
     * Listar
     *
     */
    $('#TabelaListar').DataTable({
        "processing": true,
        "serverSide": true,
        "autoWidth": true,
        "ajax": $('#TabelaListar').dataTable.pipeline({
            "url": "?m=sc&c=slideshow&a=listar",
            "pages": 5
        }),
        "columns": [
            {"data": 'codigo'},
            {"data": 'descricao'},
            {"data": 'status'},
            {"data": 'acoes'}
        ],
        //Define a coluna default que ser ordenada quando abrir a pgina
        "order": [[0, "desc"]],

        //Organiza os botoes, paginao, campos e notificaes
        dom: '<"btnAdicionar">lfrtip',

        //Define as opes de quantidade de linhas que apareco na lista
        "lengthMenu": [[10, 25, 50], [10, 25, 50]],

        //Define as colunas que no tero ordenao
        "columnDefs": [
            {
                "orderable": false,
                "targets": -1,
                "searchable": false
            }
        ],

        //Pensonalizando as mensagens que por default so em ingls e formatao de valores
        language: {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "",
            "sInfoEmpty": "",
            "sInfoFiltered": "",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Busca",
            "oPaginate": {
                "sNext": "Prximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "ltimo"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            },
            "decimal": ",",
            "thousands": "."
        }
    });

    var btnAdicionar = '<a class="btn btn-success" href="?m=sc&c=slideshow&a=adicionar"><i class="fa fa-plus-circle"></i> Adicionar</a>';
    $("div.btnAdicionar").html(btnAdicionar);

    //Funcao que inativa ou ativa o slideshow
    $(document).on('click', '.btnInativar', function() {
        var id_slideshow = $(this).val();
        $.ajax({
            type:'POST',
            url: '?m=sc&c=slideshow&a=inativar',
            dataType: 'json',
            data: {id_slideshow: id_slideshow},
            success: function(data) {
                if (data.fl_ativo == '1') {
                    $('#status_'+id_slideshow).html('<span class="label label-success">Ativo</span>');
                    $('#icon_'+id_slideshow).attr('class','fa fa-lock');
                    $('#button_'+id_slideshow).attr('data-original-title','INATIVAR');
                } else {
                    $('#status_'+id_slideshow).html('<span class="label label-danger">Inativo</span>');
                    $('#icon_'+id_slideshow).attr('class','fa fa-unlock-alt');
                    $('#button_'+id_slideshow).attr('data-original-title','ATIVAR');
                }
            }
        });
    });

});
