$(document).ready(function () {

    /**
     * Listar
     *
     */
    $('#TabelaListar').DataTable({
        "processing": true,
        "serverSide": true,
        "autoWidth": true,
        "ajax": $('#TabelaListar').dataTable.pipeline({
            "url": "?m=sc&c=logAcesso&a=listar",
            "pages": 5
        }),
        "columns": [
            {"data": 'nmPessoa'},
            {"data": 'idUsuario'},
            {"data": 'dtAcesso'},
            {"data": 'hrAcesso'},
            {"data": 'dtSaida'},
            {"data": 'hrSaida'},
            {"data": 'ipAcesso'}
        ],
        //Define a coluna default que ser ordenada quando abrir a pgina
        "order": [[1, "desc"]],

        //Organiza os botoes, paginao, campos e notificaes
        dom: '<"btnAdicionar">lfrtip',

        //Define as opes de quantidade de linhas que apareco na lista
        "lengthMenu": [[10, 25, 50], [10, 25, 50]],

        //Define as colunas que no tero ordenao
        "columnDefs": [
            {
                "orderable": false,
                "targets": 4,
                "searchable": false
            }
        ],

        //Pensonalizando as mensagens que por default so em ingls e formatao de valores
        language: {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "",
            "sInfoEmpty": "",
            "sInfoFiltered": "",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Busca",
            "oPaginate": {
                "sNext": "Prximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "ltimo"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            },
            "decimal": ",",
            "thousands": "."
        }
    });    
});
