$(document).ready(function () {
    /*
     * **Listar
     */
    $('#TabelaListar').DataTable({
        "processing": true,
        "serverSide": true,
        "autoWidth": true,
        "ajax": $('#TabelaListar').dataTable.pipeline({
            "url": "?m=sc&c=layout&a=listar",
            "pages": 5
        }),
        "columns": [
            {"data": 'checkbox'},
            {"data": 'id_tabela_preco'},
            {"data": "empreendimento"},
            {"data": "tp_tabela"},
            {"data": "acoes"}
        ],
        //Define a coluna default que será ordenada quando abrir a página
        "order": [[1, "asc"]],

        //Organiza os botoes, paginação, campos e notificações
        dom: '<"btnMais"><"btnAdicionar"><"btnCriar">lfrtip',

        //Define as opções de quantidade de linhas que aparecão na lista
        "lengthMenu": [[10, 25, 50], [10, 25, 50]],

        //Define as colunas que não terão ordenação

        //Pensonalizando as mensagens que por default são em inglês e formatação de valores
        language: {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "",
            "sInfoEmpty": "",
            "sInfoFiltered": "",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Busca",
            "oPaginate": {
                "sNext": "Próximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "Último"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            },

            "decimal": ",",
            "thousands": "."
        },

       
    });

    //Botão "Adicionar" da listagem de todas telas
    var btnAdicionar = '<a class="btn btn-success" href="?m=sc&c=layout&a=criar" style="margin-right: 10px;"><i class="fa fa-plus-circle"></i> Criar</a>';


    $("div.btnAdicionar").html(btnAdicionar);

});
function mudaTipoTb(element) {
    var id_tabela_preco = $(element).attr('id');
    var tipo = $(element).attr('name');

    $.ajax({
        type: "POST",
        url: "?m=sc&c=layout&a=mudaTipoTb",
        data: {
            "id_tabela_preco": id_tabela_preco,
            "tipo": tipo
        },
        success: function (response) {
            $response = JSON.parse(response);
            if ($response.save) {
                if ($response.value == '1') {
                    $(element).attr('class', 'label label-danger');
                    $(element).text('Não');
                    alert('Operação realizada.');
                } else if ($response.value == '0') {
                    $(element).attr('class', 'label label-success');
                    $(element).text('Sim');
                    alert('Operação realizada.');
                } else {
                    alert('Já existe uma tabela como padrão. Desative-a primeiro antes de definir outra.');
                }
            } else {
                alert('Não foi possível realizar a operação.');
            }
        },
        error: function () {
            alert("Erro ao acessar o banco de dados.");
        }
    });
}