$.fn.editable.defaults.mode = 'inline';
//Varivel global para uso da DataTable
var Table;

$(document).ready(function () {
    console.log
    if($("#tipo_layout").val() == "APIINTER"){
        $("#campoInter")[0].style.display="";
    }
    if($("#tipo_layout").val() == "APISICREDI"){
        $("#campoSicredi")[0].style.display="";
    }
    if($("#tipo_layout").val() == "APIUNICRED"){
        $("#campoUnicred")[0].style.display="";
    }
    maskMoney();
    $("#formModal").submit(function () {
        salvarSelecionados();
    });
    
    $('#quadra').change(function (e) {
        alert('Algum erro ocorreu.'); 
    });
});


function adicionar(linha){
      alert(linha);
  $("#divPrincipal").append("<h1>Valor da linha:"+linha+" </h1>");
}
function carregarTbLotes() {
    
    var columns = [];

    if ($('#tabelaPreco').attr('tipo') != 'N') {
        columns = [            
            {"data": 'checkbox'},
            {"data": 'id'},
            {"data": "nm_layout"},
            {"data": "dt_layout"},
        ];
    } else {
        columns = [
            {"data": 'checkbox'},
            {"data": 'quadra'},
            {"data": "lote"},
            {"data": "area"},
        ];
    }

    Table = $("#tableValues").DataTable({

        "processing": true,
        // Destri a tabela feita e reconstri uma nova
        destroy: true,
        
        ajax: {
            'url': "?m=sc&c=layout&a=",
            'type': "POST",
            'data': function (data) {
                data.quadra = $("#quadra").val();
                data.empreendimento = $("#Empreendimento").val();
                data.tabela = $('#tabelaPreco').attr('value');
                data.tpTabela = $('#tabelaPreco').attr('tipo');
            }
        },

        "columns": columns,

        "select": {
            "style": 'multi'
        },

        "columnDefs": [
            { "orderable": false, "targets": 0 },
            { "width": "140px", "targets": 3 }
        ],
        //Define a coluna default que ser ordenada quando abrir a pgina
        "order": [[2, "asc"]],

        //Organiza os botoes, paginao, campos e notificaes
        dom: 'T<"#dtb-title">lfrtip',

        //Define as opes de quantidade de linhas que apareco na lista
        "lengthMenu": [[10, 20, 50, -1], [10, 20, 50, "Todos"]],
        
        //Personalizando as mensagens que por default so em ingls e formatao de valores
        language: {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "",
            "sInfoEmpty": "",
            "sInfoFiltered": "",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Busca",
            "oPaginate": {
                "sNext": "Prximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "ltimo"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            },

            "decimal": ",",
            "thousands": "."
        },

        "drawCallback": function( settings ) {
            criaEditor();
            criaModal();
        },
        
    });
}

function criaEditor() {    
    $('#tableValues td > div').each(function (e) {
        // Se o name tiver 'vl' ele adiciona a classe autoEdit
        var inputcl = ($(this).attr('name').indexOf('vl') > -1) ? 'autoEdit' : '';

        $(this).editable({
            name: $(this).attr('name'),
            type: 'text',
            pk: $(this).attr('id'),
            url: '?m=cadastro&c=tabelaPreco&a=mudarValorTb',
            showbuttons: false,
            emptytext: '&nbsp;', //Sem valor fica espao em branco     
            inputclass: inputcl,
            success: function(response) {
                response = JSON.parse(response);
            },
            error: function () {
                alert('Algum erro ocorreu.');
            },
            clear: false
        })
    });        
}

function maskMoney() {
    $('.maskMoney').mask('#.###.###.##0,00', {reverse: true});
    $(document).on("focus", ".autoEdit", function () {
        $(this).mask('#.###.###.##0,00', {reverse: true});
    });
}

function criaModal() {
    var btnEditarSelecionados = '<a class="btn btn-success btn-sm btnTb"><i class="icon-edit"></i> Editar Selecionados</a>&nbsp;&nbsp;';
    var btnAddLote = '<a class="btn btn-primary btn-sm btnAdd"><i class="fa fa-plus-circle"></i> Adicionar Lote</a>';

    $(".DTTT_container").html(btnEditarSelecionados + btnAddLote);

    $(".btnTb").on('click', function(e) {   
        e.preventDefault();
        if ($('input[name="chk[]"]:checked').length > 0) {
            alert("Cuidado! Todos os lotes selecionados sero atualizados, tenha em mente que esta ao  irreversvel.");
            $('#modalEditarTb').modal('show');
        } else {
            alert('Selecione ao menos um lote antes.');
        }
    });

    $(".btnAdd").on('click', function () {
        addNovaLinha();
    });
}

function addNovaLinha() {
    $.ajax({
        type: "POST",
        url: "?m=cadastro&c=tabelaPreco&a=listarLotes",
        data: { 
            quadra: $("#quadra").val(),
            emp: $("#Empreendimento").val(),
            tabela: $("#tabelaPreco").attr('value'),
        },
        success: function (response) {
            response = JSON.parse(response);
            if (response.lotes) {
                Table.destroy();
                $.when(addRowTable(response.lotes)).done(maskMoney());
            } else {
                alert('No h lotes disponveis nesta quadra.');
            }
        },
        error: function (response) {
            alert('Erro com a conexo entre em contato com o suporte.');
            location.reload();
        }
    });
}

function addRowTable(lotes) {
    $("#quadra").attr('disabled',true); //Desativa a opo de mudana de quadra para evitar duplicao
    var table = document.getElementById("tableValues");
    var quadra = $("#quadra").val();

    var row = table.insertRow(2);    
   
    var cell = [];

    if ($('#tabelaPreco').attr('tipo') == 'N') {
        for (let index = 0; index <= 11; index++) {
            cell[index] = row.insertCell(index);
        }
        if (quadra != "*") {
            cell[1].innerHTML = `<span style="display: table; margin: 0 auto">${quadra}</span>`;
        } else {
            cell[1].innerHTML = `<select id="selecQuadra" style="display: table; margin: 0 auto"></select>`;
        }
        cell[2].innerHTML = '<select id="selecLotes" style="display: table; margin: 0 auto"></select>';
        cell[3].innerHTML = '<span style="display: table; margin: 0 auto" id="area"></span>';
        cell[4].innerHTML = '<input name="addVlTotal" required="required" class="maskMoney" style="text-align:right;width:100%;float:right"></input>';
        cell[5].innerHTML = '<input name="addVlSinal" class="maskMoney" style="text-align:right;width:100%;float:right"></input>';
        cell[6].innerHTML = '<input name="addVlParcela" class="maskMoney" style="text-align:right;width:100%;float:right"></input>';
        cell[7].innerHTML = '<input name="addQtdeMensal" style="text-align:center;width:100%;display: table; margin: 0 auto"></input>';
        cell[8].innerHTML = '<input name="addVlIntercalada" class="maskMoney" style="text-align:right;width:100%;float:right"></input>';
        cell[9].innerHTML = '<input name="addQtIntercalada" style="text-align:center;width:100%;display: table; margin: 0 auto"></input>';
        cell[10].innerHTML = '<input name="addPerIntercalada" style="text-align:center;width:100%;display: table; margin: 0 auto">';
        cell[11].innerHTML = '<button type="submit" id="btnAdd" style="display: table; margin: 0 auto">Salvar</button>';
    } else {
        for (let index = 0; index <= 7; index++) {
            cell[index] = row.insertCell(index);
        }
        if (quadra != "*") {
            cell[1].innerHTML = `<span style="display: table; margin: 0 auto">${quadra}</span>`;
        } else {
            cell[1].innerHTML = `<select id="selecQuadra" style="display: table; margin: 0 auto"></select>`;
        }
        cell[2].innerHTML = '<select id="selecLotes" style="display: table; margin: 0 auto"></select>';
        cell[3].innerHTML = '<span style="display: table; margin: 0 auto" id="area"></span>';
        cell[4].innerHTML = '<input name="addVlTotal" required="required" class="maskMoney" style="text-align:right;width:100%;float:right"></input>';
        cell[5].innerHTML = '<input name="addTxJuros" required="required" style="text-align:right;width:100%;float:right"></input>';
        cell[6].innerHTML = '<input name="addQtMeses" required="required" style="text-align:center;width:100%;display: table; margin: 0 auto"></input>';
        cell[7].innerHTML = '<button type="submit" id="btnAdd" style="display: table; margin: 0 auto">Salvar</button>';
    }

    if (quadra == "*") {
        var selectQuadra = document.getElementById("selecQuadra");
        var arrQuadras = [];
        lotes.forEach(element => {
            // Condio para no haver duplicaes
            if (!arrQuadras.includes(element.quadra)) {
                arrQuadras.push(element.quadra);
                var opt = document.createElement('option');
                opt.appendChild( document.createTextNode(element.quadra) );
                opt.value = element.quadra;
                selectQuadra.appendChild(opt);
            }
        });
        $("#selecQuadra").change(function(e) {
            e.preventDefault();
            $.ajax({
                type: "POST",
                url: "?m=cadastro&c=tabelaPreco&a=listarLotes",
                data: { 
                    quadra: $("#selecQuadra").val(),
                    emp: $("#Empreendimento").val(),
                    tabela: $("#tabelaPreco").attr('value'),
                },
                success: function (response) {
                    response = JSON.parse(response);
                    if (response.lotes) {
                        var select = document.getElementById("selecLotes");
                        $("#selecLotes").empty();
                        
                        response.lotes.forEach(element => {
                            var opt = document.createElement('option');
                            opt.appendChild(document.createTextNode(element.lote));
                            opt.value = element.id;
                            opt.setAttribute('area', element.area);
                            opt.setAttribute('quadra', element.quadra);
                            select.appendChild(opt);

                            document.getElementById("area").innerHTML = `${select.options[select.selectedIndex].getAttribute("area")}m`;

                            select.addEventListener('change', (event) => {
                                var area = document.getElementById("area");
                                area.innerHTML = `${select.options[select.selectedIndex].getAttribute("area")}m`;
                            });
                        });
                    } else {
                        alert('No h lotes disponveis nesta quadra.');
                    }
                },
                error: function (response) {
                    alert('Erro com a conexo entre em contato com o suporte.');
                    location.reload();
                }
            });
        });
        $("#selecQuadra").change(); //Para atualizar os lotes atuais
    } else {
        var select = document.getElementById("selecLotes");

        lotes.forEach(element => {
            var opt = document.createElement('option');
            opt.appendChild( document.createTextNode(element.lote) );
            opt.value = element.id;
            opt.setAttribute('area', element.area);
            opt.setAttribute('quadra', element.quadra);
            select.appendChild(opt);
        });

        document.getElementById("area").innerHTML = `${select.options[select.selectedIndex].getAttribute("area")}m`;

        select.addEventListener('change', (event) => {
            var area = document.getElementById("area");
            area.innerHTML = `${select.options[select.selectedIndex].getAttribute("area")}m`;
        });
    }

    var form = document.getElementById("editarTabelaPrecoLotes");

    form.addEventListener('submit', e => {
        salvarNovoLote();
    });
}
function salvarSelecionados() {
    var size = $('input[name="chk[]"]:checked').length;
    $('input[name="chk[]"]:checked').each(function(i){
        var id_tb_lote = $(this).attr('id');
        $.ajax({
            type: "POST",
            url: "?m=cadastro&c=tabelaPreco&a=mudarValorTb",
            data: {
                'id_tb_preco_lotes': id_tb_lote,
                'vl_total': $('input[name="vlTotal"]').val(),
                'vl_sinal': $('input[name="vlSinal"]').val(),
                'vl_parcela': $('input[name="vlParcela"]').val(),
                'nr_parcela': $('input[name="qtdeMensal"]').val(),
                'vl_intercalada': $('input[name="vlIntercalada"]').val(),
                'fr_intercalada': $('input[name="perIntercalada"]').val(),                
                'qt_intercalada': $('input[name="qtIntercalada"]').val(),
                'tx_juros': $('input[name="txJuros"]').val(),
                'qt_meses': $('input[name="qtMeses"]').val()
            },
            success: function (response) {
                response = JSON.parse(response);
                if (i+1 === size) {
                    alert(size + ' lotes foram modificados com sucesso.');
                    location.reload();
                } 
            },
            error: function (response) {
                alert('Erro com a conexo entre em contato com o suporte.');
                location.reload();
            }
        });
    });
}
function salvarNovoLote() {
    var id_lote = $('#selecLotes').val();
    $.ajax({
        type: "POST",
        url: "?m=cadastro&c=tabelaPreco&a=criarNovaLinha",
        data: {
            'id_lote': id_lote,
            'id_tabela_preco': $('#tabelaPreco').attr('value'),
            'vl_total': $('input[name="addVlTotal"]').val(),
            'vl_sinal': $('input[name="addVlSinal"]').val(),
            'vl_parcela': $('input[name="addVlParcela"]').val(),
            'nr_parcela': $('input[name="addQtdeMensal"]').val(),
            'vl_intercalada': $('input[name="addVlIntercalada"]').val(),
            'fr_intercalada': $('input[name="addPerIntercalada"]').val(),            
            'qt_intercalada': $('input[name="addQtIntercalada"]').val(),
            'tx_juros': $('input[name="addTxJuros"]').val(),
            'qt_meses': $('input[name="addQtMeses"]').val()
        },
        success: function (response) {
            response = JSON.parse(response);
            if (response.save == 1) {
                alert('Lote adicionado com sucesso.');
            } else {
                alert('No foi possvel adicionar este lote.')
            }
            location.reload();            
        },
        error: function (response) {
            alert('Erro com a conexo entre em contato com o suporte.');
            location.reload();
        }
    });
}
$('#tipo_layout').change(function (event) {
    if($("#tipo_layout").val() == "APIINTER"){
        $("#campoInter")[0].style.display="";
    }
    else{

        $("#campoInter")[0].style.display="none";
    }
 });