$(document).ready(function () {
     /**
     * Service para buscar remotamente o endereo
     * https://viacep.com.br/
     */
    $(".cep").mask("99999-999").on('blur', function () {
        $.getJSON("//viacep.com.br/ws/" + $(this).val() + "/json/?callback=?", function (dados) {
            if (!("erro" in dados)) {
                $("#nm_bairro").val(dados.bairro);
                $("[name='cd_cidade']").attr("required", true);
                $('#cepDesconhecido').html('');
                $.ajax({
                    type: "GET",
                    url: "index.php?m=lo&c=ajax&a=find_cidade",
                    data: "term=" + removeAcento(dados.localidade)+'&uf='+dados.uf,
                    success: function (data) {
                        var obj = jQuery.parseJSON(data)[0];
                        $('#cidade').html('<option value="' + obj.id + '" selected>' + obj.value + '</option>').trigger('change');
                    }
                });
            } //end if.
            else {
                //CEP pesquisado no foi encontrado.
                $(this).val(null);
                $('#cepDesconhecido').html('<a href="https://viacep.com.br/cep/" target="_blank">No encontrou o CEP?</a>');
                $("[name='cd_cidade']").attr("required", true);
            }
        });
    });

    //Funo de mascara para telefone do Outorgante!
    $(".nrTel").mask("00000-0000");
    $(".dddTel").mask("00");

    //Funo que verifica qual mscara usar de acordo o que foi digitado, se  CPF ou CNPJ
    $("#nrCnpjCpf").blur( function() {
        var nrCnpjCpf = $("#nrCnpjCpf").val(),
            nrCnpjCpf = nrCnpjCpf.replace(/[^0-9]/g,''),
            value;

        if (nrCnpjCpf.length <= 11) {
            value = nrCnpjCpf.substring(0, 3);
            value += '.'+nrCnpjCpf.substring(3, 6);
            value += '.'+nrCnpjCpf.substring(6, 9);
            value += '-'+nrCnpjCpf.substring(9, 11);
        } else {
            value = nrCnpjCpf.substring(0, 2);
            value += '.'+nrCnpjCpf.substring(2, 5);
            value += '.'+nrCnpjCpf.substring(5, 8);
            value += '/'+nrCnpjCpf.substring(8, 12);
            value += '-'+nrCnpjCpf.substring(12, 14);
        }

        $("#nrCnpjCpf").val(value);
    });
    carregarDocusign();
    $.ajax({
        type: "get",
        url: "?m=sc&c=docusign&a=empreendimentos",
        dataType: 'json',
        success: function (obj) {
            obj.forEach(empreendimento => {
                $("#empreendimento").append("<option value=\""+empreendimento.id+"\">"+empreendimento.nm_empreendimento+"</option>")
            });
        }
    });
});

function carregarDocusign(){
    $("#tabelaDocusign").html("Carregando...");
    var settings = {
        "url": "?m=sc&c=docusign",
        "method": "GET",
        "timeout": 0
      };
      
      $.ajax(settings).done(function (response) {
        $("#tabelaDocusign").html("");
        obj = JSON.parse(response);
        obj.forEach(docusign => {
            $("#tabelaDocusign").append(`
                <tr id="docusign`+docusign.id+`">
                    <td> `+(docusign.nm_empreendimento?docusign.nm_empreendimento:"Todos")+`</td>
                    <td> `+docusign.docusign_id_cliente+`</td>
                    <td> `+docusign.docusign_integration_key+`</td>
                    <td>
                        <div align="center" style="width: 100%;">
                            <button onclick="editarDocusign(`+docusign.id+`)" class="btn btn-success btn-xs" type="button" title="Editar" data-toggle="modal" data-target="#docusignModal">
                                Editar
                            </button>
                            <button onclick="removerDocusign(`+docusign.id+`)" class="btn btn-danger btn-xs" type="button" title="Remover"><i class="fa fa-times"></i>
                            </button>
                        </div>
                    </td>
                </tr>
            `);
        });
        
      });
}

function editarDocusign(id){
    $("#docusign_id_cliente").val("");
    $("#docusign_integration_key").val("");
    $("#docusign_secret_key").val("");
    $("#docusign_nome").val("");
    $("#docusign_email").val("");
    $("#autorizarDocusign").html('<button disabled class="btn btn-success" title="Salve os tokens do Docusign!" style="width:100%">Autorizar Docusign</button>')
    $("#homologarDocusign").html('<button disabled class="btn btn-success" title="Faa a autorizao do Docusign!" style="width:100%">Homologao da API</button>');
        
    $("#docusign_id").val("");
    $("#empreendimento").val("-1");
    var settings = {
        "url": "?m=sc&c=docusign&id="+id,
        "method": "GET",
        "timeout": 0
      };
      
      $.ajax(settings).done(function (response) {
        obj = JSON.parse(response)[0];
        $("#docusign_id").val(obj.id);
        $("#empreendimento").val(obj.docusign_empreendimento);
        if(obj.docusign_id_cliente)
            $("#docusign_id_cliente").val(obj.docusign_id_cliente);
        if(obj.docusign_integration_key)
            $("#docusign_integration_key").val(obj.docusign_integration_key);
        $("#docusign_secret_key").val(obj.docusign_secret_key);
        $("#docusign_nome").val(obj.docusign_nome);
        $("#docusign_email").val(obj.docusign_email);
        
        $("#autorizarDocusign").html('<a href="https://account.docusign.com/oauth/auth?response_type=code&scope=signature&state='+obj.id+'-2&client_id='+obj.docusign_integration_key+'&redirect_uri=https://'+dominio+'.acadeone.com.br/acadelotear/docusign.php" class="btn btn-success" style="width:100%;margin-bottom:10px;" >Autorizar Docusign em produo</a><a href="https://account-d.docusign.com/oauth/auth?response_type=code&scope=signature&state='+obj.id+'-1&client_id='+obj.docusign_integration_key+'&redirect_uri=https://'+dominio+'.acadeone.com.br/acadelotear/docusign.php" class="btn btn-success" style="width:100%" >Autorizar Docusign em sandbox</a>')
        
        if(obj.docusign_access_token){
            $("#homologarDocusign").html('<button onClick="homologarDocusign(1,'+obj.id+');" class="btn btn-success" style="width:100%" >Homologao da API</button>')
        }
        else{
            $("#homologarDocusign").html('<button disabled class="btn btn-success" title="Faa a autorizao do Docusign!" style="width:100%" >Homologao da API</button>');
        }
    });
}
function atualizarDocusign(){
    if(!$("#docusign_id_cliente").val()||
        !$("#empreendimento").val()||
        !$("#docusign_integration_key").val()||
        !$("#docusign_secret_key").val()||
        !$("#docusign_nome").val()||
        !$("#docusign_email").val()){
            alert("Preencha todos os campos!");
            return false;
    }
    var form = new FormData();
    form.append("docusignId",$("#docusign_id").val());
    form.append("docusign_id_cliente",$("#docusign_id_cliente").val());
    form.append("docusign_empreendimento",$("#empreendimento").val());
    form.append("docusign_integration_key",$("#docusign_integration_key").val());
    form.append("docusign_secret_key",$("#docusign_secret_key").val());
    form.append("docusign_nome",$("#docusign_nome").val());
    form.append("docusign_email",$("#docusign_email").val());

    var settings = {
        "url": "?m=sc&c=docusign&a=atualizar",
        "method": "POST",
        "timeout": 0,
        "processData": false,
        "mimeType": "multipart/form-data",
        "contentType": false,
        "data": form
    };

    $.ajax(settings).done(function (response) {
        carregarDocusign();
        $("#docusignModal").modal('hide');
    });

}
function removerDocusign(id){
    
    var form = new FormData();
    form.append("docusignId",id);

    var settings = {
        "url": "?m=sc&c=docusign&a=deletar",
        "method": "POST",
        "timeout": 0,
        "processData": false,
        "mimeType": "multipart/form-data",
        "contentType": false,
        "data": form
    };

    $.ajax(settings).done(function (response) {
        carregarDocusign();
    });

}
function selectChange(select) {
}

function validateImagem() {
    var fuData = document.getElementById('dsEndLogomarca');
    var FileUploadPath = fuData.value;

    //To check if user upload any file

    var Extension = FileUploadPath.substring(
        FileUploadPath.lastIndexOf('.') + 1).toLowerCase();

    //The file uploaded is an image

    if (Extension == "jpeg" || Extension == "jpg") {

        // To Display
        if (fuData.files && fuData.files[0]) {
            var reader = new FileReader();

            reader.onload = function (e) {
                $('#blah').attr('src', e.target.result);
            }

            reader.readAsDataURL(fuData.files[0]);
        }
    }
    //The file upload is NOT an image
    else {
        alert("Apenas imagem em JPG  permitido.");
        $('#dsEndLogomarca').val('');
    }

}
document.querySelector("#copy-button").onclick = function() {
    // Select the content
    document.querySelector("#linkDocusign").select();
    // Copy to the clipboard
    document.execCommand('copy');
    $("#copy-button")[0].style.backgroundColor="#68C39F";
    $("#copy-button")[0].style.color="#FFFFFF";
    setTimeout(() => {
        
        $("#copy-button")[0].style.backgroundColor="";
        $("#copy-button")[0].style.color="";
    }, "2000")
};
document.querySelector("#copy-button1").onclick = function() {
    // Select the content
    document.querySelector("#linkDocusignEvento").select();
    // Copy to the clipboard
    document.execCommand('copy');
    $("#copy-button")[0].style.backgroundColor="#68C39F";
    $("#copy-button")[0].style.color="#FFFFFF";
    setTimeout(() => {
        
        $("#copy-button")[0].style.backgroundColor="";
        $("#copy-button")[0].style.color="";
    }, "2000")
};
function homologarDocusign(id,docusign){
    
    $("#progressoHomologacao").width(parseInt((id*4.76)-2.38)+"%");
    $("#progressoHomologacao").text(parseInt((id*4.76)-2.38)+" %");

    $.get( "?m=sc&c=cliente&a=homologacaoDocusign&id="+id+"&idDocusign="+docusign, function( data ) {
        obj = JSON.parse(data);
        if(obj.envelopeId){
            $("#progressoHomologacao").width(parseInt(id*4.76)+"%");
            $("#progressoHomologacao").text(parseInt(id*4.76)+" %");
            if(id<=20){
                homologarDocusign(id+1,docusign);
            }
            else{
                $("#progressoHomologacao").width("100 %");
                $("#progressoHomologacao").text("100 %");
            }
        }
        else{
            alert("ERRO!!!<br>"+data);
        }
    });

}

function gerarNovoToken(){
    var form = new FormData();
    form.append("id", $("#id").val());

    var settings = {
        "url": "?m=sc&c=cliente&a=gerarTokenApi",
        "method": "POST",
        "timeout": 0,
        "processData": false,
        "mimeType": "multipart/form-data",
        "contentType": false,
        "data": form,
        "dataType":"json"
    };

    $.ajax(settings).done(function (response) {
        if(response.token){
            $("#tokenCliente").html(response.token);
        }
    });
}