$(document).ready(function () {  
    
    graficoVendasPorMesAno();
    graficoDistratosPorMesEano();
    graficoParcelasPagasNoMes();
    graficoLotes();

    $('select').change(function (e) { 
        e.preventDefault();
        $('#formPost').submit();
    });

    $('#dataRet').on('changeDate blur', function () {
        $("#btnSalvaAgendamento").attr('href', $("#btnSalvaAgendamento").attr('href') + '&novaData=' + $('#dataRet').val());
    });

    setTimeout(exibeAvisoDeAtualizacoes, 1000);


    $('#btnAtualizacaoLida').on('click', function() {
        
        $.ajax({
            type: 'POST',
            url: '?c=aviso&a=atualizaStatusMensagemAtualizacao&mensagem=' + $('#idAvisoTelaInicial').val(),
            dataType: 'json',
            success: function (response) {
                if (response)
                    $('#modalAtualizacao').modal('hide');
                else {
                    $('#modalAtualizacao').modal('hide');
                    alert('Ocorreu um erro ao atualizar a mensagem, por favor entre em contato com o suporte.')
                }
            }
        });
    });
});

document.querySelector('.button-menu-mobile').addEventListener('click', function() {
  setTimeout(function() {
      // Redimensionar os grficos quando o menu lateral for recolhido ou expandido
      var distratosChart = echarts.getInstanceByDom(document.getElementById('distratos'));
      var vendasChart = echarts.getInstanceByDom(document.getElementById('vendas'));
      var parcelasChart = echarts.getInstanceByDom(document.getElementById('parcelas'));
      var lotesChart = echarts.getInstanceByDom(document.getElementById('lotes'));
      distratosChart.resize();
      vendasChart.resize();
      parcelasChart.resize();
      lotesChart.resize();
  }, 300);
  });

function graficoVendasPorMesAno() {
    // Initialize the echarts instance based on the prepared dom
    var myChart = echarts.init(document.getElementById('vendas'));
	myChart.showLoading();
  function resizeChart(){
    myChart.resize();
  }
  window.addEventListener('resize', resizeChart);

    $.ajax({
        type: 'POST',
        url: '?m=sc&c=graficos&a=buscaVendasPorMesEano&idEmpreendimento='+$('#empreendimento').val(),
        dataType: 'json',
        success: function(response) {
            
            option = {
                title: {
                  text: 'Vendas por ms/ano'
                },
                tooltip: {
                  trigger: 'axis'
                },
                legend: {
                    bottom: 10,
                    data: ['Ano passado', 'Ano atual']
                },
                grid: {
                  left: '3%',
                  right: '4%',
                  bottom: '10%',
                  containLabel: true
                },
                toolbox: {
                  show: true,
                  feature: {
                    dataZoom: {
                      yAxisIndex: 'none'
                    },
                    dataView: { readOnly: true },
                    magicType: { type: ['line', 'bar'] },
                    restore: {},
                    saveAsImage: {}
                  }
                },
                xAxis: {
                  type: 'category',
                  boundaryGap: false,
                  data: ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez']
                },
                yAxis: {
                  type: 'value'
                },
                series: [
                  {
                    name: 'Ano passado',
                    type: 'line',
                    data: response.anoAnterior,
                    color:[
                      '#168c7d'
                    ]
                  },
                  {
                    name: 'Ano atual',
                    type: 'line',
                    data: response.anoAtual,
                    color:[
                      '#B01B3c'
                    ]
                  }
                ]
            };

			myChart.hideLoading();
            myChart.setOption(option);
            resizeChart();
        }
    });
}

function graficoDistratosPorMesEano() {
    // Initialize the echarts instance based on the prepared dom
    var myChart = echarts.init(document.getElementById('distratos'));
	myChart.showLoading();
  function resizeChart(){
    myChart.resize();
  }
  window.addEventListener('resize', resizeChart);

    $.ajax({
        type: 'POST',
        url: '?m=sc&c=graficos&a=buscaDistratosPorMesEano&idEmpreendimento='+$('#empreendimento').val(),
        dataType: 'json',
        success: function(response) {
            
            option = {
                title: {
                  text: 'Distratos por ms/ano'
                },
                tooltip: {
                  trigger: 'axis'
                },
                legend: {
                    bottom: 10,
                    data: ['Ano passado', 'Ano atual']
                },
                grid: {
                  left: '3%',
                  right: '4%',
                  bottom: '10%',
                  containLabel: true
                },
                toolbox: {
                  show: true,
                  feature: {
                    dataZoom: {
                      yAxisIndex: 'none'
                    },
                    dataView: { readOnly: true },
                    magicType: { type: ['line', 'bar'] },
                    restore: {},
                    saveAsImage: {}
                  }
                },
                xAxis: {
                  type: 'category',
                  boundaryGap: false,
                  data: ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez']
                },
                yAxis: {
                  type: 'value'
                },
                series: [
                  {
                    name: 'Ano passado',
                    type: 'line',
                    smooth: true,
                    data: response.anoAnterior,
                    color:[
                      '#168c7d'
                    ]
                  },
                  {
                    name: 'Ano atual',
                    type: 'line',
                    smooth: true,
                    data: response.anoAtual,
                    color:[
                      '#B01B3c'
                    ]
                  }
                ]
            };

			myChart.hideLoading();
            myChart.setOption(option);
            resizeChart();
        }
    });
}

function graficoParcelasPagasNoMes() {
    // Initialize the echarts instance based on the prepared dom
    var myChart = echarts.init(document.getElementById('parcelas'));
	myChart.showLoading();
  function resizeChart(){
    myChart.resize();
  }
  window.addEventListener('resize', resizeChart);

    $.ajax({
        type: 'POST',
        url: '?m=sc&c=graficos&a=buscaParcelasPagasNoMes&idEmpreendimento='+$('#empreendimento').val(),
        dataType: 'json',
        success: function(response) {
            
            option = {
                title: {
                    text: 'Parcelas pagas'
                },
                tooltip: {
                  trigger: 'axis',
                  axisPointer: {
                    type: 'shadow'
                  }
                },
                toolbox: {
                  show: true,
                  feature: {
                    mark: { show: true },
                    dataView: { show: true, readOnly: true },
                    restore: { show: true },
                    saveAsImage: { show: true }
                  }
                },
                grid: {
                  left: '3%',
                  right: '4%',
                  bottom: '3%',
                  containLabel: true
                },
                xAxis: [
                  {
                    type: 'category',
                    data: ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'],
                    axisTick: {
                      alignWithLabel: true
                    }
                  }
                ],
                yAxis: [
                  {
                    type: 'value'
                  }
                ],
                series: [
                  {
                    name: 'Quantidade',
                    type: 'bar',
                    barWidth: '60%',
                    data: response.total,
                    color:[
                      '#B01B3c'
                    ]
                  },
                  {
                    name: 'Total pago',
                    type: 'bar',
                    barWidth: '60%',
                    data: response.vlTotalParcela,
                    color:[
                      '#168c7d'
                    ]
                  }
                ]
            };

			myChart.hideLoading();
            myChart.setOption(option);
            resizeChart();
        }
    });
}

function graficoLotes() {
  // Initialize the echarts instance based on the prepared dom
  	var myChart = echarts.init(document.getElementById('lotes'));
  	myChart.showLoading();
  	function resizeChart(){
      myChart.resize();
    }
    window.addEventListener('resize', resizeChart);

  $.ajax({
      type: 'POST',
      url: '?m=sc&c=graficos&a=buscaTotaisSituacaoLote&idEmpreendimento='+$('#empreendimento').val(),
      dataType: 'json',
      success: function(response) {
       
        if (response.todosLotes == null) {
          response.todosLotes = 0;
          response.disponiveis = 0;
          response.vendidos = 0;
          response.quitados = 0;
          response.negociacao = 0;
          response.reservaTecnica = 0;
          response.reservados = 0;
        }

        $('.lotes-disponiveis').html('<b>' + response.disponiveis + '</b>');
        option = {
            title: {
              text: 'Lotes',
              subtext: 'Total: ' + response.todosLotes,
              left: 'left'
            },
            tooltip: {
              trigger: 'item'
            },
            legend: {
              orient: 'horizontal',
              bottom: 'bottom'
            },
            toolbox: {
              show: true,
              feature: {
                mark: { show: true },
                dataView: { show: true, readOnly: true },
                restore: { show: true },
                saveAsImage: { show: true }
              }
            },
            series: [
              {
                type: 'pie',
                radius: '50%',
                label: {
                  show: true,
                  formatter(params) {
                    if (params.value == 0)
                      return 0;
                    // calcula porcentagem
                    return formatAsPercentage((params.value * 100) / response.todosLotes);
                  }
                },
                data: [
                  { value: response.vendidos, itemStyle: {color: '#FF0000'}, name: 'Vendidos' },
                  { value: response.disponiveis, itemStyle: {color: '#3CB371'}, name: 'Disponveis' },
                  { value: response.quitados, itemStyle: {color: '#9400D3'}, name: 'Quitados' },
                  { value: response.negociacao, itemStyle: {color: '#00BFFF'}, name: 'Negociao' },
                  { value: response.reservaTecnica, itemStyle: {color: '#FF8C00'}, name: 'Reserva tcnica' },
                  { value: response.reservados, itemStyle: {color: '#FFFF00'}, name: 'Reservados' },
                ],
                emphasis: {
                  itemStyle: {
                    shadowBlur: 10,
                    shadowOffsetX: 0,
                    shadowColor: 'rgba(0, 0, 0, 0.5)'
                  }
                }
              }
            ]
        };

		    myChart.hideLoading();
        myChart.setOption(option);
        resizeChart();
        }
    });
}

function exibeAvisoDeAtualizacoes() {
    $.ajax({
        type: 'POST',
        url: '?c=aviso&a=buscaAtualizacoes',
        dataType: 'json',
        success: function(response) {
            
            if (response.idAviso != null) {
                $('#conteudoAtualizacao').html(response.conteudo);
                $('#idAvisoTelaInicial').val(response.idAviso);
                $('#tituloAtualizacao').html(response.titulo);
                $('#modalAtualizacao').modal('show');
            }
        }
    });
}

function reagendar(id){
    $("#btnSalvaAgendamento").attr("href", "index.php?m=&c=admin&a=reagendamentosalvar&id=");
    $("#btnSalvaAgendamento").attr('href', $("#btnSalvaAgendamento").attr('href') + id);
    $("#btnSalvaAgendamento").attr('href', $("#btnSalvaAgendamento").attr('href') + '&novaData=' + $('#dataRet').val());
    
    $.ajax({
        type: 'POST',
        url: '?m=adm&c=relacionamentoAgendamento&a=reagendar&id=' + id,
        dataType: 'json',
        success: function (data) {
            $('#cliente').html(data.data.nm_pessoa);
            $('#clienteContrato').html(data.data.idContrato);
            $('#clienteQuadra').html(data.data.quadra);
            $('#clienteLote').html(data.data.lote);
            $('#dtRetorno').html(data.data.dt_retorno);
            $('#assunto').html(data.data.assunto);
        }
    });
    

    $('#modalReagendar').modal('show');
}

function formatAsPercentage(num) {
  return new Intl.NumberFormat('default', {
    style: 'percent',
    minimumFractionDigits: 2,
    maximumFractionDigits: 2,
  }).format(num / 100);
}