
$(document).ready(function () {
    
    $('#divSubTotalizar').show();
    $('[name="ordem"]').on('ifChecked', function (event) {
        if ($(this).val() == 'Q') {
            $('#divSubTotalizar').hide();
        } else if ($(this).val() == 'P') {
            $('#divSubTotalizar').hide();
        } else {
            $('#divSubTotalizar').show();
        }
    });
    $('[name="tipoRelatorio"]').on('ifChecked', function (event) {
        if ($(this).val() == "html") {
            $('.span120dias').hide();
        } else {
            $('.span120dias').show();
        }
    });
    
    $('#pesquisar').on('click', function (e) {
        $('#visualizarInput').val('true');
        $("input[name*='tipoRelatorio']").val('html');  

        var $form = $('#form'),
            params = $form.serializeArray(),
            formData = new FormData();

        $.each(params, function (i, val) {
            formData.append(val.name, val.value);
        });

        $.ajax({
            url: "?m=rl&c=relatorioPagas&a=relatorio",
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            type: 'POST',
            beforeSend: function () {
                $('#pesquisar').disable = true;
                $('#receiver').empty();
                $('#receiver').html('Carregando....');
            },
            success: function (json) { 
                var jsonWithErrors = (json.length <= 201) ? JSON.parse(json): '';
                
                if (jsonWithErrors.msgErros) {
                    $(window).scrollTop(0);
                     $('.msgErros').html(jsonWithErrors.msgErros).show();
                    setTimeout(function () {
                        $('.msgErros').slideUp();
                        $('#receiver').empty();
                    }, 5000);
                } else {                                                       
                    $('.middle').slideUp(800);
                    $('#hide-content').css('display', 'block');
                    $('#receiver').empty();
                    $('#receiver').html(json);           
                    $('html, body').animate({ scrollTop: $('.row').offset().top }, 'slow');
                }

            }
        });
    });


    $('#pdf').on('click', function (e) {
        e.preventDefault();
        $('#visualizarInput').val('false');        
        $("input[name*='tipoRelatorio']").val('pdf');   
        $('#form').attr('target', '_self');

        var $form = $('#form'),
            params = $form.serializeArray(),
            formData = new FormData();

        $.each(params, function (i, val) {
            formData.append(val.name, val.value);
        });

        $.ajax({
            url: "?m=rl&c=relatorioPagas&a=relatorio",
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            type: 'POST',
            beforeSend: function () {
                $('#pdf').disable = true;
            },
            success: function (json) {
                json = JSON.parse(json);
                if (json.msgErros) {
                    $(window).scrollTop(0);
                    $('.msgErros').html(json.msgErros).show();
                    setTimeout(function () {
                        $('.msgErros').slideUp();
                    }, 5000);
                } else {
                    $("#form").attr('target',  '_blank');   
                    $('form').submit();
                }      
            }
        })
    });

    $('#xls').on('click', function (e) {
        e.preventDefault();
        $('#visualizarInput').val('false');
        $("input[name*='tipoRelatorio']").val('xls');   
        $('#form').attr('target', '_self');

        var $form = $('#form'),
            params = $form.serializeArray(),
            formData = new FormData();

        $.each(params, function (i, val) {
            formData.append(val.name, val.value);
        });

        $.ajax({
            url: "?m=rl&c=relatorioPagas&a=relatorio",
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            type: 'POST',
            beforeSend: function () {
                $('#xls').disable = true;
            },
            success: function (json) {
                json = JSON.parse(json);
                if (json.msgErros) {
                    $(window).scrollTop(0);
                    $('.msgErros').html(json.msgErros).show();
                    setTimeout(function () {
                        $('.msgErros').slideUp();
                    }, 5000);
                } else {                    
                    $("#form").attr('target',  '_blank');
                    $('form').submit();
                }
            }
        })
    });

    $('#hide-content').on('click', function(e) {
        $('.middle').slideDown(800);
        $('#hide-content').css('display', 'none');
        $('html, body').animate({ scrollTop: $('.content').offset().top }, 'medium');
    });


    //Exibe o aviso de limite de datas at 120 dias apenas se o cliente for individual
    $('#cliente_relatorio_parcela_paga').on('change', function(){
        if ($(this).val() != '*') {
            $('.span120dias').hide();
        } else {
            $('.span120dias').show();
        }
    });
});
//Funo para change do select2 funcionar mais tranquilamente
function selectChange(select) {
    if (select.hasClass('empreendimentoParcelaPaga')) {
        $("#cliente_relatorio_parcela_paga").prop('disabled', false);
        $("#cliente_relatorio_parcela_paga").empty();
        //reseta o campo select, fazendo com que o mesmo receba o valor default
        $('#banco').empty();
        $.ajax({
            type: "POST",
            url: "?m=rl&c=relatorioPagas&a=clienteParcelasPagas",
            data: "id_empreendimento=" + select.val(),
            success: function (response) {
                var json = JSON.parse(response);
                if (json) {
                    $('.span120dias').show();
                    $("#cliente_relatorio_parcela_paga").prop('disabled', false);
                    $("#cliente_relatorio_parcela_paga").select2({
                        'data': json,
                        'placeholder': 'Escolha o Cliente',
                        'allowClear': true,
                        'language': {
                            "noResults": function () {
                                return "Nenhum resultado encontrado";
                            },
                            "searching": function () {
                                return "Pesquisando...";
                            }
                        }
                    });
                    $('#cliente_relatorio_parcela_paga').val('*').trigger('change.select2');
                }
            }
        });
        $.ajax({
            type: "POST",
            url: "?m=rl&c=relatorioPagas&a=loteByEmpreendimento",
            data: "id_empreendimento=" + select.val(),
            success: function (response) {
                var json = JSON.parse(response);
                if (json) {
                    $('#receiver').empty();
                    $('#hide-content').click();
                    $("#quadra_relatorio_parcela_paga").select2({
                        'data': json,
                        'placeholder': 'Escolha a Quadra/Lote',
                        'allowClear': true,
                        'language': {
                            "noResults": function () {
                                return "Nenhum resultado encontrado";
                            },
                            "searching": function () {
                                return "Pesquisando...";
                            }
                        }
                    });
                    $('#quadra_relatorio_parcela_paga').val('*').trigger('change.select2');
                }
            }
        });
        $.ajax({
            type: "POST",
            url: "?m=rl&c=relatorioPagas&a=bancoByEmpreendimentos",
            data: "id_empreendimento=" + select.val(),
            success: function (response) {
                var json = JSON.parse(response);
                if (json) {
                    $("#banco").select2({
                        'data': json,
                        'placeholder': 'Escolha o Banco',
                        'allowClear': true,
                        'language': {
                            "noResults": function () {
                                return "Nenhum resultado encontrado";
                            },
                            "searching": function () {
                                return "Pesquisando...";
                            }
                        }
                    });
                    
                    $('#banco').val('*').trigger('change.select2');
                }
            }
        });
    }
}
function printElem(elem)
{
    //Exclui o link de ver em janela
    $('#popup').empty();

    var mywindow = window.open('', 'PRINT', 'height=1000,width=2000');
    mywindow.document.write('<html><head><title>' + document.title  + '</title>');
    mywindow.document.write('</head><body >');
    mywindow.document.write(document.getElementById(elem).innerHTML);
    mywindow.document.write('</body></html>');
    mywindow.focus();
    return true;
}