$(document).ready(function () {
    $('[name="tpCliente"]').on('ifChecked', function () {
        $("#cliente_relatorio_imposto").prop('disabled', false);
        $("#cliente_relatorio_imposto").empty();
        $.ajax({
            type: "POST",
            url: "?m=rl&c=relatorioIR&a=relatorioByImposto",
            data: "id_empreendimento=" + $("#empreendimento_relatorio_imposto").val()+
                  "&tpCliente=" + $(this).val(),
            success: function (response) {
                var json = JSON.parse(response);
                if (json) {
                    $("#cliente_relatorio_imposto").prop('disabled', false);
                    $("#cliente_relatorio_imposto").select2({
                        'data': json,
                        'placeholder': 'Escolha o Cliente',
                        'allowClear': true,
                        'language': {
                            "noResults": function () {
                                return "Nenhum resultado encontrado";
                            },
                            "searching": function () {
                                return "Pesquisando...";
                            }
                        }
                    });
                }
            }
        });
    });

    $('#gerar').on('click', function (e) {
        var $form = $('#form'),
            params = $form.serializeArray(),
            formData = new FormData();

        $.each(params, function (i, val) {
            formData.append(val.name, val.value);
        });
        $.ajax({
            url: "?m=rl&c=relatorioIR&a=relatorio",
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            type: 'POST',
            beforeSend: function () {
                $('#gerar').disable = true;
            },
            success: function (json) {
                json = JSON.parse(json);
                if (json.msgErros) {
                    $('.msgErros').html(json.msgErros).show();
                    setTimeout(function () {
                        $('.msgErros').slideUp();
                    }, 5000);
                } else {
                    $('form').submit();
                }
            }
        })
    });
});

//Funo para change do select2 funcionar mais tranquilamente
function selectChange(select) {
    
    if (select.hasClass('empreendimentoRelatorioImposto')) {
        $("#cliente_relatorio_imposto").prop('disabled', false);
        $("#cliente_relatorio_imposto").empty();
        $(".tipoCliente").show("slow");
        $.ajax({
            type: "POST",
            url: "?m=rl&c=relatorioIR&a=relatorioByImposto",
            data: "id_empreendimento=" + select.val()+
                  "&tpCliente=" + $("input[name=tpCliente]:checked").val(),
            success: function (response) {
                var json = JSON.parse(response);
                if (json) {
                    $("#cliente_relatorio_imposto").prop('disabled', false);
                    $("#cliente_relatorio_imposto").select2({
                        'data': json,
                        'placeholder': 'Escolha o Cliente',
                        'allowClear': true,
                        'language': {
                            "noResults": function () {
                                return "Nenhum resultado encontrado";
                            },
                            "searching": function () {
                                return "Pesquisando...";
                            }
                        }
                    });
                }
            }
        });
    }
}