$(document).ready(function () {
    $("#tipo").change(function () {
        if ($(this).val() == 'PCL') {
            $('#divExcel').show();
            $('#divParcelas').show();
        } else {
            if($(this).val() == 'PNP'){
                $('#divParcelas').hide();
            }
            else{
                $('#divParcelas').show();
            }
            $('#divExcel').hide();
        }
    });


    $('#gerar').on('click', function (e) {
        var $form = $('#form'),
            params = $form.serializeArray(),
            formData = new FormData();

        $.each(params, function (i, val) {
            formData.append(val.name, val.value);
        });
        $.ajax({
            url: "?m=rl&c=relParcela&a=relatorios",
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            type: 'POST',
            beforeSend: function () {
                $('#gerar').disable = true;
            },
            success: function (json) {
                json = JSON.parse(json);
                if (json.msgErros) {
                    $('.msgErros').html(json.msgErros).show();
                    setTimeout(function () {
                        $('.msgErros').slideUp();
                    }, 5000);
                } else {
                    $('form').submit();
                }
            }
        })
    })
});

//Funo para change do select2 funcionar mais tranquilamente
function selectChange(select) {
    if (select.hasClass('empreendimentoParcelaPaga')) {
        $("#cliente_relatorio_parcela_paga").prop('disabled', false);
        $("#cliente_relatorio_parcela_paga").empty();
        $.ajax({
            type: "POST",
            url: "?m=rl&c=relParcela&a=clienteParcelas",
            data: "id_empreendimento=" + select.val(),
            success: function (response) {
                var json = JSON.parse(response);
                if (json) {
                    $("#cliente_relatorio_parcela_paga").prop('disabled', false);
                    $("#cliente_relatorio_parcela_paga").select2({
                        'data': json,
                        'placeholder': 'Escolha o Cliente',
                        'allowClear': true,
                        'language': {
                            "noResults": function () {
                                return "Nenhum resultado encontrado";
                            },
                            "searching": function () {
                                return "Pesquisando...";
                            }
                        }
                    });
                    $('#cliente_relatorio_parcela_paga').val('*').trigger('change.select2');
                }
            }
        });
    }
}