$(document).ready(function () {
    $('#gerar').on('click', function (e) {

        var $form = $('#form'),
            params = $form.serializeArray(),
            formData = new FormData();

        $.each(params, function (i, val) {
            formData.append(val.name, val.value);
        });

        $.ajax({
            url: "?m=rl&c=relContato&a=validar",
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            type: 'POST',
            beforeSend: function () {
                $('#gerar').disable = true;
            },
            success: function (json) {
                json = JSON.parse(json);
                if (json.msgErros) {
                    $('.msgErros').html(json.msgErros).show();
                    setTimeout(function () {
                        $('.msgErros').slideUp();
                    }, 5000);
                } else
                    $('form').submit();
            }
        })
    })
});
function selectChange(select) {
    if (select.hasClass('empreendimentoContrato')) {
        var empreendimento = select.val();
        $("#contrato_parcela_cliente").prop('disabled', false);
        $("#contrato_parcela_cliente").empty();
        $.ajax({
            type: "POST",
            url: "?m=rl&c=relContato&a=contratoByEmpreendimento",
            data: "id_empreendimento=" + select.val(),
            success: function (response) {
                var json = JSON.parse(response);
                if (json) {
                    $("#contrato_parcela_cliente").prop('disabled', false);
                    $("#contrato_parcela_cliente").select2({
                        'data': json,
                        'placeholder': 'Escolha o Contrato',
                        'allowClear': true,
                        'language': {
                            "noResults": function () {
                                return "Nenhum resultado encontrado";
                            },
                            "searching": function () {
                                return "Pesquisando...";
                            }
                        }
                    });
                }
            }
        });
    }
}
