$(document).ready(function () {
    $('#ativos').on('ifChanged', function(event) {
        $('#empreendimento').change();
    });
    $('#inativos').on('ifChanged', function(event) {
        $('#empreendimento').change();
    });
    
    //Adiciona os tipos de acompanhamento
    $.ajax({
        type: "POST",
        url: "?m=rl&c=relAcompanhamento&a=acompanhamentoList",           
        success: function (response) {
            $("#acompanhamento").select2({
                'data': JSON.parse(response),
                'placeholder': 'Escolha o Tipo Acompanhamento',
                'allowClear': false
            });
        }
    });

    $('#gerar').on('click', function (e) {

        var $form = $('#form'),
            params = $form.serializeArray(),
            formData = new FormData();

        $.each(params, function (i, val) {
            formData.append(val.name, val.value);
        });

        $.ajax({
            url: "?m=rl&c=relAcompanhamento&a=validar",
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            type: 'POST',
            beforeSend: function () {
                $('#gerar').disable = true;
            },
            success: function (json) {
                var json = JSON.parse(json);
                console.log(json);
                if (json.msgErros) {
                    $('.msgErros').html(json.msgErros).show();
                    setTimeout(function () {
                        $('.msgErros').slideUp();
                    }, 10000);
                } else {
                    $('#form').attr('target', '_blank');
                    $('form').submit();
                }
            }
        });
    });
});

function selectChange(select) {
    if (select.hasClass('empreendimento')) {

        if ($("input[name='tipoContrato[]']:checked").size() >= 2) {
            var tipoContrato = 'todos';
        } else {
            if ($("input[name='tipoContrato[]']:checked").val() == 0) {
                var tipoContrato = 'ativos';
            } else if ($("input[name='tipoContrato[]']:checked").val() == 1) {
                var tipoContrato = 'inativos';
            }
        }

        $.ajax({
            type: "POST",
            url: "?m=rl&c=relAcompanhamento&a=contratoByEmpreendimento",
            data: {
                "id_empreendimento": select.val(),
                "tipoContrato": tipoContrato
            },
            success: function (response) {                 
                var todos = $('#contratoParcela').val() == 'todos'?true:false;      
                $("#contratoParcela").select2({
                    'data': JSON.parse(response),
                    'placeholder': 'Escolha o Contrato',
                    'allowClear': false                        
                });
                if (todos) {
                    $('#contratoParcela').val('todos').trigger('change');
                }
            }
        });

    }

}
