$(document).ready(function () {
    $('#gerar').on('click', function (e) {

        var $form = $('#form'),
            params = $form.serializeArray(),
            formData = new FormData();

        $.each(params, function (i, val) {
            formData.append(val.name, val.value);
        });

        $.ajax({
            url: "?m=rl&c=protocolo&a=validar",
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            type: 'POST',
            beforeSend: function () {
                $('#gerar').disable = true;
            },
            success: function (json) {
                json = JSON.parse(json);
                if (json.msgErros) {
                    $('.msgErros').html(json.msgErros).show();
                    setTimeout(function () {
                        $('.msgErros').slideUp();
                    }, 5000);
                } else
                    $('form').submit();
            }
        })
    })
});
//Funo para change do select2 funcionar mais tranquilamente
function selectChange(select) {
    if (select.hasClass('empreendimentoContratoData')) {
        var empreendimento = select.val();
        $("#contratoParcelaRestante").html('<option value="*">Carregando...</option>');
        $("#contratoParcelaRestante").prop('disabled', true);
        $("#contratoParcelaRestante").val('*').trigger('change');
        $.ajax({
            type: "POST",
            url: "?m=rl&c=protocolo&a=contratoEmpreendimento",
            data: "id_empreendimento=" + select.val(),
            success: function (response) {
                var json = JSON.parse(response);
                if (json) {
                    $("#contratoParcelaRestante").html('');
                    $("#contratoParcelaRestante").prop('disabled', false);
                    $("#contratoParcelaRestante").select2({
                        'data': json,
                        'placeholder': 'Escolha o Contrato',
                        'allowClear': true,
                        'language': {
                            "noResults": function () {
                                return "Nenhum resultado encontrado";
                            },
                            "searching": function () {
                                return "Pesquisando...";
                            }
                        }
                    });
                }
            }
        });
    }
}

$('#contratoParcelaRestante').on('change', function () {
    if ($(this).val() != '*') {
        $.ajax({
            type: "POST",
            url: "?m=rl&c=protocolo&a=getAssinatura",
            data: { contrato: $(this).val(), empreendimento: $('#empreendimento_contrato_data').val() },
            success: function (response) {
                const meses = ["Janeiro", "Fevereiro", "Maro", "Abril", "Maio", "Junho", "Julho", "Agosto", "Setembro", "Outubro", "Novembro", "Dezembro"];
                let data = new Date()
                let data_formatada = ((data.getDate() + ", " + meses[(data.getMonth())] + " de " + data.getFullYear()))
                let cidade = response.nome

                if (cidade != '' && cidade != 'undefined' && cidade != null)
                    $('#assinatura').val(cidade + ", " + data_formatada + ".")
            }
        })
    }
})