$(document).ready(function () {
    $('#tipo').on('change', function () {
        $('#clienteLbl').hide();
        if ($(this).val() == 'LD') {
            $('#divExibirSitu').hide();
            $('#divExibirRel').show();
            $('#divExibirConf').show();
        } 
        else if ($(this).val() == 'F') {
            $('#divExibirSitu').show();
            $('#divExibirRel').show();
            $('#divExibirConf').hide();
        }
        else if ($(this).val() == 'S') {
            $('#divExibirSitu').show();
            $('#divExibirRel').show();
            $('#divExibirConf').hide();
        }
        else if ($(this).val() == 'V') {
            $('#clienteLbl').show();
        }
        else {
            $('#divExibirSitu').hide();
            $('#divExibirRel').show();
            $('#divExibirConf').hide();
        }
    });

    $('#gerar').on('click', function (e) {

        var $form = $('#form'),
            params = $form.serializeArray(),
            formData = new FormData();

        $.each(params, function (i, val) {
            formData.append(val.name, val.value);
        });

        $.ajax({
            url: "?m=rl&c=loteRelatorio&a=validar",
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            type: 'POST',
            beforeSend: function () {
                $('#gerar').disable = true;
            },
            success: function (json) {
                json = JSON.parse(json);
                if (json.msgErros) {
                    $('.msgErros').html(json.msgErros).show();
                    setTimeout(function () {
                        $('.msgErros').slideUp();
                    }, 5000);
                } else
                    $('form').submit();
            }
        })
    })
});

//Funo para change do select2 funcionar mais tranquilamente
function selectChange(select) {
    if (select.hasClass('empreendimentoLote')) {
        $("#lote_relatorio_lote").html('<option value="">Selecione ...</option>');
        $.ajax({
            type: "POST",
            url: "?m=rl&c=loteRelatorio&a=quadraByEmprendimento",
            data: "id_empreendimento=" + select.val(),
            success: function (response) {
                if (response) {
                    $("#lote_relatorio_lote").select2({
                        'data': JSON.parse(response),
                        'placeholder': 'Escolha a Quadra',
                        'allowClear': false
                    });
                    $("#lote_relatorio_lote").val('*').trigger('change');
                    $("#lote_relatorio_lote").attr('disabled', false);
                    $("#tipo").val('T').trigger('change');
                    $("#tipo").attr('disabled', false);
                } else {
                    $("#lote_relatorio_lote").html('<option value="vazio">Nenhuma quadra encontrada</option>');
                    $("#lote_relatorio_lote").val('vazio').trigger('change');
                    $("#lote_relatorio_lote").attr('disabled', true);
                    $("#tipo").attr('disabled', true);
                }
            }
        });
    }
    if (select.hasClass('quadraRelatorio')) {
        $.ajax({
            type: "POST",
            url: "?m=rl&c=loteRelatorio&a=loteByEmprendimento",
            data: "id_empreendimento=" + $("#id_empreendimento").val() + "&quadra=" + select.val(),
            success: function (response) {
                if (response) {
                    $("#loteRelatorio").select2({
                        'data': JSON.parse(response),
                        'placeholder': 'Escolha o Lote',
                        'allowClear': false
                    });
                    $("#loteRelatorio").val('*').trigger('change');
                    $("#loteRelatorio").attr('disabled', false);
                    $("#tipo").val('T').trigger('change');
                    $("#tipo").attr('disabled', false);
                } else {
                    $("#loteRelatorio").html('<option value="vazio">Nenhum lote encontrado</option>');
                    $("#loteRelatorio").val('vazio').trigger('change');
                    $("#loteRelatorio").attr('disabled', true);
                }
            }
        });
    }
}