$(document).ready(function () {
/**
     * Listar
     *
     */

    $('#TabelaListar').DataTable({

        "processing": true,
        "ajax": "index.php?m=portal&c=permissoes&a=listar",
        "columns": [
            {"data": 'codigo'},
            {"data": 'empreendimento'},
            {"data": 'boleto'},
            {"data": 'alteraDados'},
            {"data": 'negociacao'},
            {"data": 'extrato'},
            {"data": 'impostoRenda'},
            {"data": 'acoes'}
        ],

        //Define a coluna default que ser ordenada quando abrir a pgina
        "order": [[0, "desc"]],

        //Organiza os botoes, paginao, campos e notificaes
        dom: '<"btnAdicionar">lfrtip',

        //Define as opes de quantidade de linhas que apareco na lista
        "lengthMenu": [[10, 25, 50], [10, 25, 50]],

        //Define as colunas que no tero ordenao
        "columnDefs": [
            {
                "orderable": false,
                "targets": -1,
                "searchable": false
            },
            {
                "className": "dt-center", "targets": [0,2,3,4,5]
            }
        ],

        //Pensonalizando as mensagens que por default so em ingls e formatao de valores
        language: {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "",
            "sInfoEmpty": "",
            "sInfoFiltered": "",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Busca",
            "oPaginate": {
                "sNext": "Prximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "ltimo"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            },

            "decimal": ",",
            "thousands": "."
        },

        initComplete: function () {

            //Botão "Adicionar" da listagem de todas telas
            var btnAdicionar = '<a class="btn btn-success" href="?m=portal&c=permissoes&a=alterar"><i class="fa fa-plus-circle"></i> Adicionar</a>';

            $("div.btnAdicionar").html(btnAdicionar);
        }
    });
});

function mudaTipoTb(element) {
    var idPermissao = $(element).attr('id');
    var tipo = $(element).attr('name');

    $.ajax({
        type: "POST",
        url: "?m=portal&c=permissoes&a=mudaTipoTb",
        data: {
            "idPermissao": idPermissao,
            "tipo" : tipo
        },
        success: function (response) {
            $response = JSON.parse(response);
            
            if ($response.save) {
                if ($response.value != 'Ativo') {
                    $(element).attr('class', 'label label-danger');
                    $(element).text('Inativo');
                    alert('Operao realizada com sucesso.');
                } else if ($response.value != 'Inativo') {
                    $(element).attr('class', 'label label-success');
                    $(element).text('Ativo');
                    alert('Operao realizada com sucesso.');
                } else {
                    alert('No foi possvel realizar esta operao.');
                }
            } else {
                alert('No foi possvel realizar esta operao.');
            }
        },
        error: function () {
            alert("Erro ao acessar o banco de dados.");
        }
    });
}