$(document).ready(function () {
    $('#TabelaListar').DataTable({
        "ajax": "?m=portal&c=login&a=listaLogin",
        "columns": [
            { "data": "nm_empreendimento"  },
            { "data": "quadra" },
            { "data": "lote"  },
            { "data": "nm_pessoa"  },
            { "data": "login"  },
            { "data": "acoes" }
        ],
        dom: '<"btnAdicionar">lfrtip',
        "order": [[1, "asc"]],

        //Define as colunas que não terão ordenação
        "columnDefs": [
            {
                "targets": 0,
                "width": '350px',
                className: 'dt-left'
            },
            {
                "targets": 1,
                "width": "200px"
            },
            {
                "targets": 2,
                "width": "200px"
            },
            {
                "targets": 3,
                "width": '350px',
                className: 'dt-left'
            },
            
            {
                "orderable": false,
                "targets": -1,
                "searchable": false,
                "width": '120px'
            }
        ],
        "lengthMenu": [[10, 25, 50], [10, 25, 50]],
        //Pensonalizando as mensagens que por default são em inglês e formatação de valores
        language: {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "",
            "sInfoEmpty": "",
            "sInfoFiltered": "",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Busca",
            "oPaginate": {
                "sNext": "Próximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "Último"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            },

            "decimal": ",",
            "thousands": "."
        }
    });
    //Botão "Adicionar" da listagem de todas telas
    var btnAdicionar = '<a class="btn btn-success" href="?m=portal&c=login&a=form"><i class="fa fa-plus-circle"></i> Gerar Login</a>';
    $("div.btnAdicionar").html(btnAdicionar);


});

// Modelo word
function imprimeWord(id) {

    $('#modalModeloWord').modal('show');
    $('#contrato').remove();
    
    $.ajax({
        type: 'POST',
        url: '?m=portal&c=login&a=imprimeWord&id=' + id,
        dataType: 'json',
        success: function (data) {
            $("select.modeloWord").html('<option value="">Selecione ...</option>');
            $('.modeloWord').append($('<option>', {
                value: '',
                text: 'Selecione...'
            })).prop('selected', 'selected').trigger('change');
            $.each(data['arquivos'], function (i, item) {
                var option = new Option(item.text, item.value, true, true)
                $('.modeloWord').append(option).trigger('change');
            });
            $('.modeloWord').val(null).trigger('change');

            $('<input>').attr({
                type: 'hidden',
                id: 'contrato',
                value: id
            }).appendTo('#form');
        }
    });
     
}

function resetar (id)
{
    $.ajax({
        type : 'POST',
        url : '?m=portal&c=login&a=resetar&id=' + id,
        dataType : 'json',
        success : function (data)
        {
            if (data)
            {
                alert('Senha resetada com sucesso!');
            } else {
                alert('No foi possvel resetar a senhad desse cliente!');
            }
        }
    });
}

$('#doModalWord').on('click', function (e) {
    var modeloWord = $('#arquivo option:selected').val()
    var contrato = $('#contrato').val()
    if(modeloWord == undefined) {
        alert("Escolha um modelo word!");
    } else {
        window.open('index.php?m=portal&c=login&a=imprime&tpcarta=' + modeloWord + '&id=' + contrato + '&w=w', '_blank')
    }
});

$('#doModalWord').on('hidden.bs.modal', function () {
    $('#arquivo option:selected').empty().trigger('change');
});

// Visualizar
function visualizar(id) {
    $.ajax({
        type: 'POST',
        url: '?m=portal&c=login&a=view&id=' + id,
        dataType: 'json',
        success: function (data) {
           console.log(data.data);
            $('#clientePortal').html(data.data.nm_pessoa);
            $('#clienteContrato').html(data.data.id_contrato);
            $('#clienteQuadra').html(data.data.quadra);
            $('#clienteLote').html(data.data.lote);
            $('#clienteLogin').html(data.data.login);

            if(data.data.alterado == 1){
                $('#labelSenha').hide();
            }
            else{
                $('#labelSenha').show();
                $('#clienteSenha').html(data.data.senha);
            }
        }
    });

    $('#modalView').modal('show');
}

//deletar login
function deletar(element) {
    var codigo = $(element).attr('value');
    if (confirm('Você deseja continuar?')) {
        $.ajax({
            method: "POST",
            url: '?m=portal&c=login&a=deletar',
            data: {
                codigo: codigo
            },
            success: function (response) {
                try {
                    var response = JSON.parse(response);
                } catch (r){
                    alert("Você não tem permissão para realizar esta ação");
                }

                if (response.response == 'true') {
                    alert('Login foi deletado com sucesso');
                } else {
                    alert('Não foi possível realizar esta ação');
                }
                location.reload();
            }
        });
    }
}
    //relatório login e senha do cliente
   /* function relatorio(element) {
        var codigo = $(element).attr('value');

            $.ajax({
                method: "POST",
                url: '?m=portal&c=login&a=relatorio',
                data: {
                    codigo: codigo
                },
                success: function (response) {
                    try {
                        var response = JSON.parse(response);
                    } catch (r){
                        alert("Você não tem permissão para realizar esta ação");
                    }

                    if (response.response == 'true') {
                        alert('Login: '+ response.login + ' ' + 'Senha: '+ response.passwd);
                    } else {
                        alert('Não foi possível realizar esta ação');
                    }
                    location.reload();
                }
            });
}*/

//relatorio login e senha
function relatorio(element){

    var codigo = $(element).attr('value');

    $.ajax({
        type: 'POST',
        url: "?m=portal&c=login&a=relatorio",
        data: {
            codigo: codigo
        },

        success: function (data) {
            console.log('ok')
        }
    });


}
