$(document).ready(function () {
    $('#TabelaListar').DataTable({
        "ajax": "?m=portal&c=aprovar&a=listaAprovar",
        "columns": [
            { "data": "nm_pessoa" },
            { "data": "nr_cpf" },
            { "data": "acoes" }
        ],
        dom: '<"btnAdicionar">lfrtip',
        "order": [[1, "asc"]],

        //Define as colunas que não terão ordenação
        "columnDefs": [
            {
                "targets": 0,
                "width": '120px',
                className: 'dt-left'
            },
            {
                "targets": 1,
                "width": "35%"
            },
            {
                "targets": 2,
                "width": "30px"
            },
            {
                "orderable": false,
                "targets": -1,
                "searchable": false,
                "width": '120px'
            }
        ],
        "lengthMenu": [[10, 25, 50], [10, 25, 50]],
        //Pensonalizando as mensagens que por default são em inglês e formatação de valores
        language: {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "",
            "sInfoEmpty": "",
            "sInfoFiltered": "",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Busca",
            "oPaginate": {
                "sNext": "Próximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "Último"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            },

            "decimal": ",",
            "thousands": "."
        }
    });



});



//visualizar dados alterados pelo cliente
function visualizar(element){
    var codigo = $(element).attr('value');

    $.ajax({
        type: 'POST',
        url: "?m=portal&c=aprovar&a=visualizarAprovar",
        data: {
            codigo: codigo
        },
        beforeSend: function () {
            $("#modalVisualizar .modal-body").html('<div align="center">Carregando. . . <a class="loading"></a></div>');
        },
        success: function (data) {
             $("#modalVisualizar .modal-body").html(data);
        }
    });


}


function aprovar(element)
{
    var aprovar = $(element).attr('value');
    $.ajax({
        method: 'POST',
        url: "index.php?m=portal&c=aprovar&a=aprovar",
        data: {
            aprovar: aprovar
        },
        success: function (response) {

       try{
        var retorno = JSON.parse(response);
       }catch(r){
           alert("Você não tem permissão para execultar estar ação");
           location.reload();
       }

         if(retorno.response == 'true'){
             alert("Dados aprovado e alterado com sucesso");

         }else{
            alert("Não foi possivel  alterar os dados");
         }
        location.reload();

        }
    });
}

function desaprovar(element)
{
    var desaprovar = $(element).attr('value');
    $.ajax({
        method: 'POST',
        url: "index.php?m=portal&c=aprovar&a=desaprovar",
        data: {
            desaprovar: desaprovar
        },
        success: function (response) {

        try{
            var retorno = JSON.parse(response);
           }catch(r){
               alert("Você não tem permissão para execultar estar ação");
               location.reload();
           }

         if(retorno.response == 'true'){
             alert("Dados desaprovado");
         }else{
            alert("Não foi possivel  desaprovar os dados");
         }
         location.reload();

        }
    });
}
