 // Resultado da requisio anterior (exemplo)
/* var points = [
  { id: 1, latitude: -6.8618727, longitude: -35.4950178 },
  { id: 2, latitude: -6.8600000, longitude: -35.5000000 },
  { id: 3, latitude: -6.8650000, longitude: -35.5050000 },
  { id: 4, latitude: -6.8700000, longitude: -35.5100000 }
];*/

// Funo para criar features (markers) a partir dos dados
var features = points.map(function(point) {
  var feature = new ol.Feature({
      geometry: new ol.geom.Point(ol.proj.fromLonLat([point.longitude, point.latitude])),
      id: point.id
  });
  return feature;
});

// Estilo do marker
var markerStyle = new ol.style.Style({
  image: new ol.style.Icon({
      scale: 0.7,
      anchor: [0.5, 1],
      src: '//raw.githubusercontent.com/jonataswalker/map-utils/master/images/marker.png'
  })
});

// Fonte de dados para o layer (contm os markers)
var vectorSource = new ol.source.Vector({
  features: features
});

// Layer que contm os markers
var vectorLayer = new ol.layer.Vector({
  source: vectorSource,
  style: markerStyle
});

// Criao do mapa
var map = new ol.Map({
  target: 'map',
  layers: [
      new ol.layer.Tile({
          source: new ol.source.OSM()
      }),
      vectorLayer
  ],
  view: new ol.View({
      center: ol.proj.fromLonLat([-35.4950178, -6.8618727]),
      zoom: 14
  })
});

// Elemento de popup
var popup = document.getElementById('popup');

// Cria um overlay para o popup
var overlay = new ol.Overlay({
  element: popup,
  autoPan: true,
  autoPanAnimation: {
      duration: 250
  }
});
map.addOverlay(overlay);

// Funo para exibir o popup
function showPopup(coordinate, content) {
  popup.innerHTML = content;
  overlay.setPosition(coordinate);
}

// Evento de clique no mapa
map.on('singleclick', function(evt) {
  var feature = map.forEachFeatureAtPixel(evt.pixel, function(feature) {
      return feature;
  });

  if (feature) {
      var id = feature.get('id');
      var coordinate = evt.coordinate;

      // Requisio para obter mais dados usando o ID do marker
      fetch('?m=oportunidades&c=mapa&a=getDados&id=' + id)
          .then(response => response.json())
          .then(data => {
              // Exibir os dados no popup
              var content = '<span class="fecharPopup" onclick="overlay.setPosition(undefined)">X</span><strong>Informaes:</strong><br>' +
                            'ID: <strong>' + data.id + '</strong><br>' +
                            'Oportunidade: <strong>' + data.op + '</strong><br>' +
                            'Descrio: <strong>' + data.descricao+
                            '<strong><a target="_blank" class="btn btn-primary" style="width:100%;margin-top:8px" href="?m=oportunidades&c=cadastro&a=editar&id='+data.id+'">Visualizar</a>';
              showPopup(coordinate, content);
          })
          .catch(error => {
              console.error('Erro ao obter dados:', error);
          });
  } else {
      // Fechar o popup se clicar fora de um marker
      overlay.setPosition(undefined);
  }
});
function addMarker(longitude, latitude) {
  var marker = new ol.Feature({
      geometry: new ol.geom.Point(ol.proj.fromLonLat([longitude, latitude]))
  });

  // Adiciona o marker  fonte de dados (vectorSource)
  vectorSource.addFeature(marker);
} 