var table;
var avancado = false;
$(document).ready(function () {
    atualizarDados();
    
});
function hide() {
    $('thead tr').last().toggle('1000');
}

function atualizarDados(){
    $.when( carregaDados() ).done(function( thisTable ) {
        inputAvanc(thisTable, true)
    });
}
function visualizarMinhasOportunidades(){
    minhasOportunidades=!minhasOportunidades;
    atualizarDados();
}
function visualizarFavoritos(){
    favoritos=!favoritos;
    atualizarDados();
}
function carregaDados(){
    var colunas=[];
    var url="";
    if(todos){
        url = '?m=oportunidades&c=cadastro&a=listar&todos=1&minhasOportunidades='+minhasOportunidades+'&favoritos='+favoritos+'&titulo='+($('#inputTitulo').val()|| "")+'&tipo='+($('#inputTipo').val()|| "")+'&cidade='+($('#inputCidade').val()|| "")+'&estado='+($('#inputEstado').val()|| "")+'&status='+($('#inputStatus').val()|| ""),
         colunas = [
            { data: "id_oportunidade" },
            { data: "nm_dominio" },
            { data: "op" },
            { data: "titulo" },
            { data: "cidade" },
            { data: "estado" },
            {
                data: "idStatus",
                orderable: false,
                render: function (data) {
                    data = data.split("-");
                    if(data[1] =="1"){
                        return "<button onclick='mudarStatus("+data[0]+",0,this)' class='btn btn-success botaoPequeno'>Ativo</button>";
                    }
                    return "<button onclick='mudarStatus("+data[0]+",1,this)' class='btn btn-primary botaoPequeno'>Inativo</button>";
                }
            },
            
            
            {
                data: "favorito",
                orderable: false,
                render: function (data) {
                    data = data.split("-");
                    return `<span data-toggle="modal" data-target=".modalVisualizar"> <button type="button" value="visualizar,${data[0]}" data-toggle="tooltip" title="Visualizar" class="btn btn-default btn-sm  btn-visualizar" style="margin-right:5px;margin-bottom: 5px;"><i class="fa fa-eye"></i></button></span>
                    <span data-toggle="modal" data-target=".modalVisualizar"> <button type="button" value="fotos,${data[0]}" data-toggle="tooltip" title="Fotos" class="btn btn-default btn-sm btn-visualizar" style="margin-right:5px;margin-bottom: 5px;"><i class="fa fa-photo"></i></button></span>
                    <a  href="?m=oportunidades&c=cadastro&a=editar&id=${data[0]}" data-toggle="tooltip" title="Editar" class="btn btn-default btn-sm" style="margin-right:5px;margin-bottom: 5px;"><i class="fa fa-edit"></i></a>
                    <button type="button" onclick="favoritar(${data[0]},this,${data[1]})" data-toggle="tooltip" title="Favoritar" class="btn btn-${data[1]!="0"?"success":"default"} btn-sm " style="margin-right:5px;margin-bottom: 5px;"><i class="fa fa-star"></i></button>`
                }
            },
        ];
    }
    else{
        url = '?m=oportunidades&c=cadastro&a=listar&minhasOportunidades='+minhasOportunidades+'&favoritos='+favoritos+'&titulo='+($('#inputTitulo').val()|| "")+'&tipo='+($('#inputTipo').val()|| "")+'&cidade='+($('#inputCidade').val()|| "")+'&estado='+($('#inputEstado').val()|| "")+'&status='+($('#inputStatus').val()|| ""),
         colunas = [
            { data: "id_oportunidade" },
            { data: "op" },
            { data: "titulo" },
            { data: "cidade" },
            { data: "estado" },
            {
                data: "idStatus",
                orderable: false,
                render: function (data) {
                    data = data.split("-");
                    if(data[1] =="1"){
                        return "<button onclick='mudarStatus("+data[0]+",0,this)' class='btn btn-success botaoPequeno'>Ativo</button>";
                    }
                    return "<button onclick='mudarStatus("+data[0]+",1,this)' class='btn btn-primary botaoPequeno'>Inativo</button>";
                }
            },
            
            
            {
                data: "favorito",
                orderable: false,
                render: function (data) {
                    data = data.split("-");
                    return `<span data-toggle="modal" data-target=".modalVisualizar"> <button type="button" value="visualizar,${data[0]}" data-toggle="tooltip" title="Visualizar" class="btn btn-default btn-sm  btn-visualizar" style="margin-right:5px;margin-bottom: 5px;"><i class="fa fa-eye"></i></button></span>
                    <span data-toggle="modal" data-target=".modalVisualizar"> <button type="button" value="fotos,${data[0]}" data-toggle="tooltip" title="Fotos" class="btn btn-default btn-sm btn-visualizar" style="margin-right:5px;margin-bottom: 5px;"><i class="fa fa-photo"></i></button></span>
                    <a  href="?m=oportunidades&c=cadastro&a=editar&id=${data[0]}" data-toggle="tooltip" title="Editar" class="btn btn-default btn-sm" style="margin-right:5px;margin-bottom: 5px;"><i class="fa fa-edit"></i></a>
                    <button type="button" onclick="favoritar(${data[0]},this,${data[1]})" data-toggle="tooltip" title="Favoritar" class="btn btn-${data[1]!="0"?"success":"default"} btn-sm " style="margin-right:5px;margin-bottom: 5px;"><i class="fa fa-star"></i></button>`
                }
            },
        ];
    }
    table = $('#tabelaListar').DataTable({
        ajax: url,
        responsive: true,
        processing: true,
        serverSide: true,
        destroy: true,
        orderCellsTop: true,
        autoWidth: true,
        lengthMenu: [[10, 25, 50, 100], [10, 25, 50,100]],
        columns: colunas,
        //Define a coluna default que ser ordenada quando abrir a pgina
        order: [],

        //Organiza os botes, paginao, campos e notificaes
        //dom: '<"btnAdicionar">lfrtip',
        dom: 'Blfrtip',
        buttons: [
            {
                text: 'My button',
                action: function ( e, dt, node, config ) {
                    alert( 'Button activated' );
                }
            }
        ],
        //Personalizando as mensagens que por default so em ingls e formatao de valores
        language: {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "",
            "sInfoEmpty": "",
            "sInfoFiltered": "",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Busca",
            "oPaginate": {
                "sNext": "Prximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "ltimo"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            },

            "decimal": ",",
            "thousands": "."
        }
    });
    return table;
}

function mudarStatus(id, status, botao){
    
        $.ajax({
            url: '?m=oportunidades&c=cadastro&a=mudarStatus', // URL do seu endpoint
            type: 'POST',
            data: JSON.stringify({
                id_oportunidade: id,
                status: status
            }),
            contentType: 'application/json; charset=utf-8',
            dataType: 'json',
            success: function(response) {
                if(status==0){

                    botao.classList.remove('btn-success');
                    botao.classList.add('btn-primary');
                    botao.innerHTML="Inativo";
            
                }
                else{
                    
                    botao.classList.remove('btn-primary');
                    botao.classList.add('btn-success');
                    botao.innerHTML="Ativo";
                }
            },
            error: function(xhr, status, error) {
                console.error('Erro na requisio:', error);
            }
        });
}

function favoritar(id, botao, favorito){
    var form = new FormData();
    form.append("oportunidade", id);

    var settings = {
    "url": "?m=oportunidades&c=cadastro&a=favoritar",
    "method": "POST",
    "timeout": 0,
    "processData": false,
    "mimeType": "multipart/form-data",
    "contentType": false,
    "data": form
    };

    $.ajax(settings).done(function (response) {
        response = JSON.parse(response);
        if(response.id=="-1"){
            botao.classList.remove('btn-success');
            botao.classList.add('btn-default');
        }
        else{
            botao.classList.remove('btn-default');
            botao.classList.add('btn-success');
        }
    });
}

function hide() {
    $('thead tr').last().toggle('1000');
}

function inputAvanc(table, first) {
    $(document).ready(function () {
        if(!avancado){
            // Busca avanada
            $('#tabelaListar thead tr:eq(1) th').each(function (i) {
                title = $(this).text();
                console.log(title);
                if (title == 'Titulo' || title == 'Cidade' || title == 'Estado' ) {
                    var search = '<input hide type="text" class="form-control input-sm" id="input'+title+'" style="width:100%" placeholder="' + title + '" />';            
                } 
                else if(title=='Oportunidade/Tipo'){
                    var search = `<select class="select2" style="width:100%" id="inputTipo">
                            <option value="">Selecione o tipo</option>
                            <option value="1">Venda</option>
                            <option value="2">Compra</option>
                            <option value="3">Permuta</option>
                            <option value="4">Parceria/Sociedade</option>
                            <option value="5">Servios</option>
                        </select>`;            
                }
                else if(title=='Status'){
                    var search = '<select class="select2" id="inputStatus"><option value="">Selecione o status</option><option value="0">Inativo</option><option value="1">Ativo</option></select>';            
                }
                else {
                    var search = '';
                }
                if (first) {
                    $(this).html('');
                }
                // Apply the filter
                $(search).appendTo(this).on('change',function(){atualizarDados()})
            });
            avancado=true;
        }
        $('thead tr').last().hide();
        $('.dataTables_filter').after('<a href="#" class="btn btn-sm btn-default" onClick="hide()">Busca Avanada</a>');
    });
}