var coord1 = [-5335454.138128968, -1779271.0541134963];

var lineStyle = new ol.style.Style({
  stroke: new ol.style.Stroke({ color: '#ffcc33', width: 3 })
});
var styleMarker = new ol.style.Style({
  image: new ol.style.Icon({
    scale: .7, anchor: [0.5, 1],
    src: '//raw.githubusercontent.com/jonataswalker/map-utils/master/images/marker.png'
  })
});
if(latitude && longitude){
  var marker1 = new ol.geom.Point(ol.proj.transform([ longitude,latitude], 'EPSG:4326', 'EPSG:3857'));
}
else{
  var marker1 = new ol.geom.Point(coord1);
}
var featureMarker1 = new ol.Feature(marker1);

var vector = new ol.layer.Vector({
  source: new ol.source.Vector({
  	features: [ featureMarker1]
  }),
  style: [lineStyle, styleMarker]
});
var map = new ol.Map({
	target: 'map',
  layers: [new ol.layer.Tile({ source: new ol.source.OSM() }), vector],
  view: new ol.View({ center: marker1.getCoordinates(), zoom: 10 })
});

var translate1 = new ol.interaction.Translate({
	features: new ol.Collection([featureMarker1])
});
map.addInteraction(translate1);

var coordMarker1;


map.on('pointermove', function(e) {
  if (e.dragging) return;
  var coordenadas = ol.proj.transform(marker1.getCoordinates(), 'EPSG:3857', 'EPSG:4326');
  $("#lat").val(coordenadas[1]);
  $("#long").val(coordenadas[0]);

  var hit = map.hasFeatureAtPixel(map.getEventPixel(e.originalEvent));
  map.getTargetElement().style.cursor = hit ? 'pointer' : '';
});
//ol.proj.transform(marker1.getCoordinates(), 'EPSG:3857', 'EPSG:4326')
function removerImagem(botao) {
	var formData = new FormData();
formData.append('idFoto', botao.dataset.id);

// Fazendo a requisio POST
fetch('?m=oportunidades&c=cadastro&a=removerImagem', {
		method: 'POST',
		body: formData
})
.then(response => response.json()) // Parseia a resposta como JSON
.then(data => {
		console.log('Resposta do servidor:', data);
		// Aqui voc pode adicionar cdigo para lidar com a resposta, como atualizar a interface do usurio
})
.catch(error => {
		console.error('Erro na requisio:', error);
		// Aqui voc pode adicionar cdigo para lidar com o erro
});
	// Optionally: Send a request to remove the image from the server
	
	var div = botao.parentNode;
	div.remove();
}

document.getElementById('fileInput').addEventListener('change', function(event) {
  var file = event.target.files[0];

  if (file) {
      var reader = new FileReader();
      reader.onload = function(e) {
          var img = document.createElement('img');
          img.src = e.target.result;

          var removeBtn = document.createElement('button');
          removeBtn.textContent = 'X';
          removeBtn.className = 'remove-btn';
          removeBtn.onclick = function(){removerImagem(removeBtn);};
          var div = document.createElement('div');
          div.appendChild(img);
          div.appendChild(removeBtn);
          document.getElementById('imagePreview').appendChild(div);

          // Send the image to the server
          var formData = new FormData();
          formData.append('file', file);
          formData.append('id_oportunidade', $("#id_oportunidade").val());

          fetch('?m=oportunidades&c=cadastro&a=adicionarImagem', {
              method: 'POST',
              body: formData
          })
          .then(response => response.text())
          .then(data => {
            resposta =JSON.parse(data);
            if(resposta.status==1){
              removeBtn.dataset.id=resposta.id;
            }
            else{
              alert(resposta.msg);
            }
          })
          .catch(error => {
              console.error('Erro ao fazer o upload:', error);
              alert('Erro ao fazer o upload.');
          });
      }
      reader.readAsDataURL(file);

      // Limpar o input file para permitir adicionar a mesma imagem novamente se necessrio
      fileInput.value = '';
  } else {
      alert('Por favor, selecione uma foto para adicionar.');
  }
});

document.getElementById('nr_cep').addEventListener('input', function() {
  var cep = this.value;
  if (hasEightDigits(cep)) { // Verifica se o CEP tem 8 dgitos
      var url = `https://nominatim.openstreetmap.org/search?postalcode=${cep}&country=Brazil&format=json&addressdetails=1`;

      fetch(url)
          .then(response => response.json())
          .then(data => {
              if (data.length > 0) {
                  var coordinates = data[0];
                  var latitude = parseFloat(coordinates.lat);
                  var longitude = parseFloat(coordinates.lon);
                  console.log(latitude);
                  console.log(longitude);
                  marker1.setCoordinates(ol.proj.transform([longitude,latitude], 'EPSG:4326', 'EPSG:3857'));
                  map.setView(new ol.View({ center: marker1.getCoordinates(), zoom: 10 }));
                  
                  $("#lat").val(latitude);
                  $("#long").val(longitude);
                  $("#cidade").val(coordinates.address.town);
                  $("#bairro").val(coordinates.address.suburb);
              } else {
                  alert('CEP no encontrado');
              }
          })
          .catch(error => {
              console.error('Erro ao buscar coordenadas:', error);
              document.getElementById('result').innerHTML = '<p>Erro ao buscar coordenadas.</p>';
          });
      /*var url = `https://maps.googleapis.com/maps/api/geocode/json?address=${cep}&key=AIzaSyBkqKUVukihm3VQzkzbKeOZ2BO4AXQAZyk1`
      fetch(url)
          .then(response => response.json())
          .then(data => {
              if (data.status === "OK" && data.results.length > 0) {
                  var coordinates = data.results[0];
                  const addressComponents = data.results[0].address_components;
                  let address = '';
                  let neighborhood = '';
                  let city = '';

                  // Percorre os componentes do endereo
                  addressComponents.forEach(component => {
                    // Verifica o tipo do componente
                    if (component.types.includes("route")) {
                      address = component.long_name;
                    } else if (component.types.includes("sublocality_level_1") || component.types.includes("locality")) {
                      neighborhood = component.long_name;
                    } else if (component.types.includes("administrative_area_level_2")) {
                      city = component.long_name;
                    }
                  });
                  var latitude = parseFloat(coordinates.geometry.location.lat);
                  var longitude = parseFloat(coordinates.geometry.location.lng);
                  console.log(latitude);
                  console.log(longitude);
                  marker1.setCoordinates(ol.proj.transform([longitude,latitude], 'EPSG:4326', 'EPSG:3857'));
                  map.setView(new ol.View({ center: marker1.getCoordinates(), zoom: 10 }));
                  
                  $("#lat").val(latitude);
                  $("#long").val(longitude);
                  $("#cidade").val(city);
                  $("#bairro").val(neighborhood);
                  $("#endereco").val(address);
              } else {
                  alert('CEP no encontrado');
              }
          })
          .catch(error => {
              console.error('Erro ao buscar coordenadas:', error);
              //document.getElementById('result').innerHTML = '<p>Erro ao buscar coordenadas.</p>';
          });*/
  } 
});
function hasEightDigits(str) {
  // Remove todos os caracteres que no so dgitos
  const digitsOnly = str.replace(/\D/g, '');
  
  // Verifica se a string contm exatamente 8 dgitos
  return digitsOnly.length === 8;
}
function alterar_tipo_oportunidade(select) {
  
  $("#tipo_oportunidade").val('')

  
  $("#tipo_servico_oportunidade").val('')

  if(select.value == ''){
    $("#card_tipo_oportunidade")[0].style.display="none";

    $("#card_tipo_servico_oportunidade")[0].style.display="none";

  }
  else if(select.value=='5'){
    $("#card_tipo_oportunidade")[0].style.display="none";
    $("#card_tipo_servico_oportunidade")[0].style.display=null;
    $("#tipo_servico_oportunidade")[0].setAttribute('required', true);
    if ($("#tipo_oportunidade")[0].hasAttribute('required')) {
      $("#tipo_oportunidade")[0].removeAttribute('required');
    }
  }
  else{
    
    $("#card_tipo_oportunidade")[0].style.display=null;
    $("#card_tipo_servico_oportunidade")[0].style.display="none";
    $("#tipo_oportunidade")[0].setAttribute('required', true);
    if ($("#tipo_servico_oportunidade")[0].hasAttribute('required')) {
      $("#tipo_servico_oportunidade")[0].removeAttribute('required');
    }
  }
  $("#tipo_servico_oportunidade").select2('destroy').select2();
  $("#tipo_oportunidade").select2('destroy').select2();
}
$(document).ready(function () {
  $('#estado').select2({
      placeholder: "Selecione as opes",
      allowClear: true
  });
  console.log(estadoOportunidade);
  if(estadoOportunidade){
    $('#estado').val(estadoOportunidade).trigger('change');
  }
});