$(document).ready(function () {

    carregaDados(1);

    //Busca informaes para exibir no Modal Visualizar
    $(document).on('click', '#btnVisualizar', function () {
        var id = $(this).val();

        $.ajax({
            type: 'POST',
            'url': "?m=lo&c=reservaLote&a=visualizar",
            dataType: 'json',
            data: {
                id: id,
                idLote: $(this).attr('idLote')
            },
            success: function (retorno) {
                if (retorno.obs_reserva) {
                    $('#cliente').html('Reserva Tcnica');
                    $('#corretor').html('');
                    $('#telefone').html('');
                    $('#resumo').html(retorno.obs_reserva);
                    $('#data').html(getDate(retorno.dt_reserva));
                    if(retorno.data_final){
                        $('#data_final').html(getDate(retorno.data_final));
                    }else{
                        $('#data_final').html('-');
                    }

                    $('#divCancelamento').hide();
                    $('#dtCancelamento').html('');
                    $('#obsCancelamento').html('');
                } else {
                    $('#cliente').html(retorno.nome_pessoa);
                    $('#corretor').html(retorno.nm_pessoa);
                    $('#telefone').html(retorno.telefone_pessoa);
                    $('#resumo').html(retorno.observacao);
                    $('#data').html(getDate(retorno.data_reserva));
                    if(retorno.data_final){
                        $('#data_final').html(getDate(retorno.data_final));
                    }else{
                        $('#data_final').html('-');
                    }

                    if (retorno.reservado == '0') {
                        $('#divCancelamento').show();
                        $('#dtCancelamento').html(getDate(retorno.data_cancelamento));
                        $('#obsCancelamento').html(retorno.obs_cancelamento);
                    }
                }
                $('#empreendimento').html(retorno.nm_empreendimento);
                $('#quadra').html(retorno.quadra);
                $('#lote').html(retorno.lote);
            }
        });

    });

    //Busca informaes para exibir no Modal Visualizar
    $(document).on('click', '#btnDeletar', function () {

        $('#idLote').val($(this).attr('idLote'));
        $('#idReserva').val($(this).val());

        $.ajax({
            type: 'POST',
            'url': "?m=lo&c=reservaLote&a=visualizar",
            dataType: 'json',
            data: {
                id: $(this).val(),
                idLote: $(this).attr('idLote')
            },
            success: function (retorno) {                
                $('#empreendimentoCancelar').html(retorno.nm_empreendimento);
                $('#quadraCancelar').html(retorno.quadra);
                $('#loteCancelar').html(retorno.lote);
            }
        });
    });

    $('[name="fl_tipo"]').on("ifChecked", function(e) {
        var check = $(this).val();
        carregaDados(check);
    });
    $( "input[name=tipoReserva]" ).on("ifChecked", function(){
        carregaDados( $( "input[name=fl_tipo]:checked" ).val() );
    });
});

//Funo para change do select2 funcionar mais tranquilamente
function selectChange(select) {

    if (select.hasClass('empreendimento_reserva')) {
        $("#quadraLote").html('<option value="">Selecione ...</option>');
        carregaDados(1);
        $.ajax({
            type: "POST",
            url: "?m=lo&c=reservaLote&a=findQuadraLote",
            data: "id_empreendimento=" + select.val(),
            success: function (response) {
                $("#quadraLote").select2({
                    'data': JSON.parse(response),
                    'placeholder': 'Escolha a Quadra',
                    'allowClear': true
                });
                $('#quadraLote').val($('#quadraLote option:eq(1)').val()).trigger('change');
                $("input[name='fl_tipo'][value='1']").prop("checked",true);
                $("input[name='fl_tipo']").iCheck('update')
            }
        });
    }

    if (select.hasClass('quadraLote')) {
        carregaDados(1);
    }
}

//Carregas os lotes ao selecionar uma quadra
function carregaDados(aprovar) {
    var dTbVizualizar = $('#TabelaListar').DataTable();
    //se a tabela j tiver sido inicializada, recarrega ajax
    dTbVizualizar.destroy();

    /**
     * Listar
     *
     */
    $('#TabelaListar').DataTable({
        "processing": true,
        "serverSide": true,
        "autoWidth": false,
        "ajax": $('#TabelaListar').dataTable.pipeline({
            "url": "?m=lo&c=reservaLote&a=listaByEmpreendimentoLote&aprovar="+aprovar,
            "pages": 3,
            "data": function (data) {
                data.empreendimento = $("#id_empreendimento").val();
                data.quadraLote = $("#quadraLote").val();
                data.tipoReserva = $( "input[name=tipoReserva]:checked" ).val();
            }
        }),
        "columns": [
            {"data": 'checkbox'},
            {"data": 'dataReserva'},
            {"data": 'empreendimento'},
            {"data": 'quadra'},
            {"data": 'lote'},
            {"data": 'cliente'},
            {"data": 'corretor'},
            {"data": 'acoes'}
        ],

        //Define a coluna default que ser ordenada quando abrir a pgina
        "order": [1, "asc"],

        //Organiza os botoes, paginao, campos e notificaes
        dom: '<"btnAdicionar"><"labelReservaLote">lfrtip',

        //Define as opes de quantidade de linhas que apareco na lista
        "lengthMenu": [[10, 25, 50], [10, 25, 50]],

        //Define as colunas que no tero ordenao
        "columnDefs": [
            {
                targets: [-1, 0],
                orderable: false,
                searchable: false,
                className: 'dt-center',
                width: '40px'
            },
            {
                targets: 1,
                width: '80px',
            },
            {
                targets: [3, 4],
                width: '40px'
            },
            {
                targets: 2,
                width: '150px',
            }
        ],

        //Pensonalizando as mensagens que por default so em ingls e formatao de valores
        language: {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "",
            "sInfoEmpty": "",
            "sInfoFiltered": "",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Selecione o empreendimento para listar as reservas.",
            "sSearch": "Busca",
            "oPaginate": {
                "sNext": "Prximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "ltimo"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            },

            "decimal": ",",
            "thousands": "."
        }
    });

    //Boto "Adicionar" da listagem de todas telas
    var btnAdicionar = '<a class="btn btn-success" href="?m=lo&c=reservaLote&a=adicionar"><i class="fa fa-plus-circle"></i> Adicionar</a>';
    btnAdicionar += '&nbsp<a class="btn btn-primary" href="#" onclick="return cancelarVarias()" id="cancelarVarias"><i class="fa fa-remove"></i> Desfazer</a>';
    $("div.btnAdicionar").html(btnAdicionar);

    var labelReservaLote = '<label style="color: red">As reservas de cor <b>vermelha</b> so reservas canceladas.</label>';
    $("div.labelReservaLote").html(labelReservaLote);
}

function cancelarVarias() {
    $('#cancelarVarias').find('#formCancelarVarias').empty();
    var inputsTamanho = $("input[id='cancelarCheckbox']:checked").size();

    if (inputsTamanho < 1) {
        alert('Selecione uma reserva antes!');
        return false;
    }

    $("input[id='cancelarCheckbox']:checked").each(function(i){
        
        var quadra = $(this).parent('td').nextAll().eq('2').text();
        var lote = $(this).parent('td').nextAll().eq('3').text();

        $('#cancelarVarias').find('#formCancelarVarias').append('<label class="control-label">Quadra: ' + quadra  + '</label>&nbsp;');
        $('#cancelarVarias').find('#formCancelarVarias').append('<label class="control-label">Lote: ' + lote + '</label>');

        //Lista as quadras e lotes
        //Sendo o ltimo pe ponto ao invez de vrgula
        if ((inputsTamanho - 1) == i) {
            $('#cancelarVarias').find('#formCancelarVarias').append('.');
        } else {
            $('#cancelarVarias').find('#formCancelarVarias').append(', ');
        }

        $('#cancelarVarias').find('#formCancelarVarias').append($(this).clone().hide());

    });
    $('#cancelarVarias').find('#formCancelarVarias').append('<br><br><label for="observacao" class="control-label">Observao:</label>');
    $('#cancelarVarias').find('#formCancelarVarias').append('<textarea required="required" name="observacao" class="form-control"></textarea>');
    $('#cancelarVarias').modal('show');
}