$(document).ready(function () {

    //autocomplete utilizando o plugin select2
    select2RemoteData(
        '#representantes',
        true,
        true,
        'Digite o nome, cpf ou cnpj do Cliente',
        '?m=adm&c=ajax&a=findPessoasByNome'
    );
    select2RemoteData(
        '#cd_cidade',
        false,
        true,
        'Digite o nome da Cidade',
        'index.php?m=lo&c=ajax&a=findCidade'
    );

    $("#CNPJCadastrado").blur(function () {
        if ($(this).val() != '') {
            if (validaCnpj($(this).val()))
                $.ajax({
                    type: "POST",
                    url: "?m=lo&c=pessoaJuridica&a=findPessoaJuridicaByCnpj",
                    data: {
                        cnpj: $(this).val(),
                        id: queryString('id')
                    },
                    success: function (json) {
                        var json = JSON.parse(json);

                        if (json != false) {
                            $("#CNPJCadastrado").val(null);
                            alert('CNPJ Existente!');
                        }
                    }
                });
            else {
                alert('CNPJ Invalido!');
                $(this).val(null);
            }
        }
    });

    /**
     * Service para buscar remotamente o endereo
     * https://viacep.com.br/
     */
    $(".cepPj").mask("99999-999").on('blur', function () {
        $.getJSON("//viacep.com.br/ws/" + $(this).val() + "/json/?callback=?", function (dados) {
            if (!("erro" in dados)) {
                $("#endereco").val(dados.logradouro);
                $("#nm_bairro").val(dados.bairro);
                $('#cepDesconhecido').html('');
                $.ajax({
                    type: "GET",
                    url: "index.php?m=lo&c=ajax&a=find_cidade",
                    data: "term=" + removeAcento(dados.localidade)+'&uf='+dados.uf,
                    success: function (data) {
                        var obj = jQuery.parseJSON(data)[0];
                        $('#cd_cidade').html('<option value="' + obj.id + '" selected>' + obj.nome + '</option>').trigger('change');
                    }
                });
            } //end if.
            else {
                //CEP pesquisado no foi encontrado.
                $(this).val(null);
                $('#cepDesconhecido').html('<a href="https://viacep.com.br/cep/" target="_blank">No encontrou o CEP?</a>');
                alert("CEP no encontrado.");
            }
        });
    });
    if($('#cd_cidade').val()!='9999999'){
        if(!$("#nr_celular").val()|| $("#nr_celular").val().length == 11){
            $("#nr_celular").mask("(99) 9 9999-9999");
        }
        if(!$("#nr_telefone").val()|| $("#nr_telefone").val().length == 10){
            $("#nr_telefone").mask("(99) 9999-9999");
        }
        if(!$("#nr_recado").val()|| $("#nr_recado").val().length == 11){
            $("#nr_recado").mask("(99) 9 9999-9999");
        }
    }

});

//Funo para change do select2 funcionar mais tranquilamente
function selectChange(select) {
}
$('#estrangeiro').on('ifChanged', function(event) {
    if(event.target.checked){
        $('#cd_cidade').html('<option value="9999999" selected>Estrangeiro - EX</option>').trigger('change');
        $("#cidade_estrangeira").show();
        $("#cidade").hide();
        $("#cep").hide();
        $("#nr_telefone").unmask();
        $("#nr_celular").unmask();
        $("#nr_recado").unmask();
        $("#nr_celular").val("+");
        $("#nr_telefone").val("+");
        $("#nr_recado").val("+");
    }
    else{

        $("#nr_telefone").mask("(99) 9999-9999");
        $("#nr_celular").mask("(99) 9 9999-9999");
        $("#nr_recado").mask("(99) 9 9999-9999");
        $("#nr_celular").val("");
        $("#nr_telefone").val("");
        $("#nr_recado").val("");
        $("#cidade_estrangeira").hide();
        $("#cidade").show();
        $("#cep").show();
    }
});
