$(document).ready(function () {

    select2RemoteData(
        '#cidade_nasc',
        false,
        true,
        'Digite o nome da Cidade',
        'index.php?m=lo&c=ajax&a=findCidade'
    );
    select2RemoteData(
        '#cd_cidade',
        false,
        true,
        'Digite o nome da Cidade',
        'index.php?m=lo&c=ajax&a=findCidade'
    );
    select2RemoteData(
        '#cidade_nascConjuge',
        false,
        true,
        'Digite o nome da Cidade',
        'index.php?m=lo&c=ajax&a=findCidade'
    );
    select2RemoteData(
        '#cidadeConjuge',
        false,
        true,
        'Digite o nome da Cidade',
        'index.php?m=lo&c=ajax&a=findCidade'
    );

    $("#CPFCadastrado").blur(function () {
        if ($(this).val() != '') {
            if (validaCPF($(this).val()))
                $.ajax({
                    type: "POST",
                    url: "?m=lo&c=pessoaFisica&a=findPessoaFisicaByCpf",
                    data: {
                        cpf: $(this).val(),
                        id: queryString('id')
                    },
                    success: function (json) {
                        var json = JSON.parse(json);

                        if (json != false){
                            alert('CPF j cadastrado!');
                            $(this).val(null);
                        }
                    }
                });
            else {
                alert('CPF Invalido!');
                $(this).val(null);
            }
        }
    });
    $("#nrCpfConjuge").blur(function () {
        if ($(this).val() != '') {
            if (validaCPF($(this).val()))
                $.ajax({
                    type: "POST",
                    url: "?m=lo&c=pessoaFisica&a=findPessoaFisicaByCpf",
                    data: {
                        cpf: $(this).val(),
                        id: queryString('id')
                    },
                    success: function (json) {
                        var json = JSON.parse(json);

                        if (json != false){
                            alert('CPF j cadastrado!');
                            $(this).val(null);
                        }
                    }
                });
            else {
                alert('CPF Invalido!');
                $(this).val(null);
            }
        }
    });
    $("#dt_nascimento").on('changeDate', function () {
        var idade = calculaIdade($(this).val());

        if (idade >= 18 || $(this).val() == '') {
            $("#msgIdade").html('').hide();
        } else {
            $("#msgIdade").html('AVISO - PESSOA FISICA MENOR DE IDADE.').show();
        }
    });

    $('[name="utilizarEnderecoConjuge"]').on('ifClicked', function () {
        var utilizarEnderecoConjuge = $('[name="utilizarEnderecoConjuge"]:checked').val();

        if (utilizarEnderecoConjuge == 0) {
            $('.enderecoConjuge').hide('fast');
        } else {
            $('.enderecoConjuge').show('fast');
        }
    });

    $('[name="tpNacionalidade"]').on('ifChanged', function () {
        var nacionalidade = $('[name="tpNacionalidade"]:checked').val();

        if (nacionalidade == 'E') {
            $('#divNacionalidade').show('fast');
            $('#spanCpf').hide();
            $('#CPFCadastrado').removeAttr('required');
        } else {
            $('#divNacionalidade').hide('fast');
            $('#spanCpf').show();
            $('#CPFCadastrado').attr('required', 'required');
        }
    });
    $('[name="tpNacionalidadeConjuge"]').on('ifChanged', function () {
        var nacionalidade = $('[name="tpNacionalidadeConjuge"]:checked').val();

        if (nacionalidade == 'E') {
            $('#divNacionalidadeConjuge').show('fast');
            $('#spanCpf').hide();
            $('#CPFCadastrado').removeAttr('required');
        } else {
            $('#divNacionalidadeConjuge').hide('fast');
            $('#spanCpf').show();
            $('#CPFCadastrado').attr('required', 'required');
        }
    });

    $("#est_civil").on('change', function () {
        var estCivil = $(this).val();

        if (estCivil == 'CAS' || estCivil == 'UNE') {
            $('.camposConjuge').show('fast');
            $('.enderecoConjuge').show('fast');
        } else {
            $('.camposConjuge').hide('fast');
            $('.enderecoConjuge').hide('fast');
        }
    });

    /**
     * Service para buscar remotamente o endereo
     * https://viacep.com.br/
     */

    $(".cepPf").mask("99999-999").on('blur', function () {
        $.getJSON("//viacep.com.br/ws/" + $(this).val() + "/json/?callback=?", function (dados) {
            if (!("erro" in dados)) {
                var logradouro = (dados.logradouro);
                var limite = 45;
                var limitarCaracteres = logradouro.length;
                if (limitarCaracteres > limite){
                    var logradouroLimitado = logradouro.substr(0, limite);
                    $("#endereco").val(logradouroLimitado);
                }else{
                    $("#endereco").val(dados.logradouro);
                }
                $("#nm_bairro").val(dados.bairro);
                $("[name='cd_cidade']").attr("required", true);
                $('#cepDesconhecido').html('');
                $.ajax({
                    type: "GET",
                    url: "index.php?m=lo&c=ajax&a=find_cidade",
                    data: "term=" + removeAcento(dados.localidade)+'&uf='+dados.uf,
                    success: function (data) {
                        var obj = jQuery.parseJSON(data)[0];
                        $('#cd_cidade').html('<option value="' + obj.id + '" selected>' + obj.value + '</option>').trigger('change');
                    }
                });
            } //end if.
            else {
                //CEP pesquisado no foi encontrado.
                $(this).val(null);
                $('#cepDesconhecido').html('<a href="https://viacep.com.br/cep/" target="_blank">No encontrou o CEP?</a>');
                alert("CEP no encontrado.");
                $("[name='cd_cidade']").attr("required", true);
            }
        });
    });
    if($('#cd_cidade').val()!='9999999'){
        if(!$("#nr_celular").val()|| $("#nr_celular").val().length == 11){
            $("#nr_celular").mask("(99) 9 9999-9999");
        }
        if(!$("#nr_telefone").val()|| $("#nr_telefone").val().length == 10){
            $("#nr_telefone").mask("(99) 9999-9999");
        }
        if(!$("#nr_recado").val()|| $("#nr_recado").val().length == 11){
            $("#nr_recado").mask("(99) 9 9999-9999");
        }
    }
    $(".cepPfConjuge").mask("99999-999").on('blur', function () {
        $.getJSON("//viacep.com.br/ws/" + $(this).val() + "/json/?callback=?", function (dados) {
            if (!("erro" in dados)) {
                //Atualiza os campos com os valores da consulta.
                var logradouro = (dados.logradouro);
                var limite = 45;
                var limitarCaracteres = logradouro.length;
                if (limitarCaracteres > limite){
                    var logradouroLimitado = logradouro.substr(0, limite);
                    $("#enderecoConjuge").val(logradouroLimitado);
                }else{
                    $("#enderecoConjuge").val(dados.logradouro);
                }
                $("#nmBairroConjuge").val(dados.bairro);
                $("[name='cidadeConjuge']").attr("required", true);
                $('#cepDesconhecidoConjuge').html('');
                $.ajax({
                    type: "GET",
                    url: "index.php?m=lo&c=ajax&a=findCidade",
                    data: "term=" + removeAcento(dados.localidade),
                    success: function (data) {
                        var obj = jQuery.parseJSON(data)[0];
                        $('#cidadeConjuge').html('<option value="' + obj.value + '" selected>' + obj.text + '</option>').trigger('change');
                    }
                });
            } //end if.
            else {
                //CEP pesquisado no foi encontrado.
                $(this).val(null);
                $('#cepDesconhecidoConjuge').html('<a href="https://viacep.com.br/cep/" target="_blank">No encontrou o CEP?</a>');
                alert("CEP no encontrado.");
                $("[name='cidadeConjuge']").attr("required", true);
            }
        });
    });

    $("[id='nrCpfConjuge']").on('keyup blur', function () {
        var nrCpfConjuge = $("[id='nrCpfConjuge']").removeNot({pattern: /[^0-9]+/g});
        var nrCpfConjugeAtual = $("#CPFCadastrado").removeNot({pattern: /[^0-9]+/g});

        if (nrCpfConjuge == nrCpfConjugeAtual) {
            alert('O CPF no pode ser o mesmo da Pessoa Fisica cadastrada');
            $(this).val('');
        } else {
            if (nrCpfConjuge != nrCpfConjugeAtual && nrCpfConjuge.length == 11) {
                $.ajax({
                    type: "POST",
                    url: "index.php?m=lo&c=ajax&a=verificaCpfConjuge",
                    data: {nrCpfConjuge: $(this).val()},
                    success: function (json) {
                        var json = JSON.parse(json);

                        if (json) {
                            $('#nmConjuge').val(json.nm_pessoa);
                            $('#nrRgConjuge').val(json.nr_rg);
                            $('#tpDocumentoConjuge').val(json.cd_documento).trigger('change');
                            $('#dtNascimentoConjuge').val(json.dt_nascimento);
                            $('#nmProfissaoConjuge').val(json.nm_profissao);
                            $('#nmNacionalidadeConjuge').val(json.nm_nacionalidade);
                            $('#nrTelefoneConjuge').val(json.nr_telefone);
                            $('#sexoConjuge').val(json.sexo).trigger('change');
                            $('#idConjuge').val(json.id);

                            if (json.enderecoConjuge) {
                                //Marca a opo no
                                $('#enderecoConjugeN').prop('checked', true);
                                //Exibe todos campos de endereo
                                $('.enderecoConjuge').show('fast');
                                //Coloca as informaoes nos campos
                                $('#nrCepConjuge').val(json.nr_cep);
                                $('#enderecoConjuge').val(json.endereco);
                                $('#nmBairroConjuge').val(json.nm_bairro);
                                $('#nr_enderecoConjuge').val(json.nr_endereco);
                                $('#ds_complementoConjuge').val(json.ds_complemento);
                                $('#cidadeConjuge').html('<option value="' + json.cd_cidade + '" selected>' + json.nm_cidade + ' - ' + json.uf + '</option>').trigger('change');
                                if (json.nm_cidade_nasc)
                                    $('#cidade_nascConjuge').html('<option value="' + json.cd_cidade_nasc + '" selected>' + json.nm_cidade_nasc + ' - ' + json.uf_nasc + '</option>').trigger('change');
                            } else {
                                //Marca a opo sim
                                $('#enderecoConjugeS').prop('checked', true);
                                //Marca a opo sim
                                $('.enderecoConjuge').hide('fast');
                            }
                        }
                    }
                });
            }
        }
    });

});

//Funo para change do select2 funcionar mais tranquilamente
function selectChange(select) {
    if (select.hasClass('empreendimento_contrato')) {
        $("select.lotes").html('<option value="">Selecione ...</option>');
        $("select.bancos").html('<option value="">Selecione ...</option>');
        $("select.corretores").html('<option value="">Selecione ...</option>');
        $('#maxParcelas').val($("#id_empreendimento :selected").attr('maxParcelas'));
        $.ajax({
            type: "POST",
            url: "index.php?m=adm&c=contrato&a=loteClienteByEmpreendimento",
            data: "id_empreendimento=" + select.val(),
            success: function (response) {
                $("select.lotes").select2({
                    'data': JSON.parse(response),
                    'placeholder': 'Escolha o Lote',
                    'allowClear': false
                });
            }
        });
        $.ajax({
            type: "POST",
            url: "index.php?m=adm&c=contrato&a=bancoByEmpreendimento",
            data: "id_empreendimento=" + select.val(),
            success: function (response) {
                $("select.bancos").select2({
                    'data': JSON.parse(response),
                    'placeholder': 'Escolha o Banco',
                    'allowClear': false
                });
            }
        });
        $.ajax({
            type: "POST",
            url: "index.php?m=adm&c=contrato&a=corretorByEmpreendimento",
            data: "id_empreendimento=" + select.val(),
            success: function (response) {
                $("select.corretores").select2({
                    'data': JSON.parse(response),
                    'placeholder': 'Escolha o Corretor',
                    'allowClear': false
                });
            }
        });
    }
}
$('#estrangeiro').on('ifChanged', function(event) {
    if(event.target.checked){
        $('#cd_cidade').html('<option value="9999999" selected>Estrangeiro - EX</option>').trigger('change');
        $("#cidade_estrangeira").show();
        $("#cidade").hide();
        $("#cep").hide();
        $("#nr_telefone").unmask();
        $("#nr_celular").unmask();
        $("#nr_recado").unmask();
        $("#nr_celular").val("+");
        $("#nr_telefone").val("+");
        $("#nr_recado").val("+");
    }
    else{

        $("#nr_telefone").mask("(99) 9999-9999");
        $("#nr_celular").mask("(99) 9 9999-9999");
        $("#nr_recado").mask("(99) 9 9999-9999");
        $("#nr_celular").val("");
        $("#nr_telefone").val("");
        $("#nr_recado").val("");
        $("#cidade_estrangeira").hide();
        $("#cidade").show();
        $("#cep").show();
    }
});