$(document).ready(function () {
    /**
     * Listar
     *
     */
    var table = $('#TabelaListar').dataTable({
        "ajax": $('#TabelaListar').dataTable.pipeline({
            "url": "index.php?m=lo&c=lote&a=listar",
        }),
        orderCellsTop: true,
        "columns": [
            { "data": 'excluirCheckbox' },
            { "data": 'id' },
            { "data": 'empreendimento' },
            { "data": 'quadra' },
            { "data": 'lote' },
            { "data": 'construcao' },
            { "data": 'fl_caucionado' },
            { "data": 'acoes' }
        ],

        //Define a coluna default que ser ordenada quando abrir a pgina
        "order": [[2, "asc"]],

        //Organiza os botoes, paginao, campos e notificaes
        dom: '<"btnAdicionarPlanilha"><"btnAdicionar"><"labelConstruir">lfrtip',

        //Define as opes de quantidade de linhas que aparecero na lista
        "lengthMenu": [[10, 25, 50], [10, 25, 50]],

        //Define as colunas que no tero ordenao
        "columnDefs": [
            {
                "orderable": false,
                "targets": -1,
                "searchable": false
            },
            {
                "orderable": false,
                "targets": 0,
                "searchable": false
            }
        ],

        //Pensonalizando as mensagens que por default so em inglss e formataoo de valores
        language: {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "",
            "sInfoEmpty": "",
            "sInfoFiltered": "",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Busca",
            "oPaginate": {
                "sNext": "Prximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "ltimo"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            },

            "decimal": ",",
            "thousands": "."
        }
    });

    // Busca avanada
    $('#TabelaListar thead tr:eq(1) th').each(function (i) {
        title = $(this).text();
        if (title == 'Empreendimento' || title == 'Quadra' || title == 'Lote') {
            var search = '<input hide type="text" class="form-control input-sm" style="width:100%" placeholder="' + title + '" />';            
        } else {
            var search = '';
        }
        $(this).html('');
        // Apply the filter
        $(search).appendTo(this).keyup(function(){table.fnFilter($(this).val(),i)})
    });

    $('thead tr').last().hide()
    $('.dataTables_filter').after('<a href="#" class="btn btn-sm btn-default" onClick="hide()">Busca Avanada</a>');   

});
function hide() {
    $('thead tr').last().toggle('1000');
}

function excluirVarios() {
    var ids = []
    var success = []
    $('input[name="chk[]"]:checked').each(function() {
        ids.push($(this).attr('id'))
    });

    //Validador
    if (ids.length == 0){
        alert('Selecione pelo menos um lote.')
        return false
    }
    
    if (confirm(`Deseja excluir os lotes de IDS: ${ids.join(', ')}.`)){
        ids.forEach(function(element, index, array){
            $.ajax({
                type: "GET",
                url: "?m=lo&c=lote&a=deletar",
                data: {
                    id: element
                },
                beforeSend: function() {
                    //Tela de carregando
                    if (index === 0) {                            
                        $('.modal').modal()
                        $('.modal-header').hide()
                        $('.modal-footer').hide()
                    }
                },
                success: function (json) {
                    success.push(element)
                    
                    if (index === array.length - 1){
                        alert(`Excludo os lotes de IDS: ${ids.join(', ')}.`)
                        location.reload();
                        return false
                    }
                },
                error: function() {
                    alert(`Houve um erro no lote ID: ${element}.`)
                }
            });
        })
        
    } 
}

function construirVarios(param) {
    var ids = []
    var success = []
    $('input[name="chk[]"]:checked').each(function() {
        ids.push($(this).attr('id'))
    });

    //Validador
    if (ids.length == 0){
        alert('Selecione pelo menos um lote.')
        return false
    }    
    
    if (confirm(`Alterar construo dos lotes de IDS: ${ids.join(', ')}.`)){
        ids.forEach(function(element, index, array){
            $.ajax({
                type: "POST",
                url: "?m=lo&c=lote&a=construir",
                data: {
                    id: element,
                    construcao: param
                },
                beforeSend: function() {
                    //Tela de carregando
                    if (index === 0) {                            
                        $('.modal').modal()
                        $('.modal-header').hide()
                        $('.modal-footer').hide()
                    }
                },
                success: function (json) {
                    success.push(element)
                    
                    if (index === array.length - 1){
                        alert(`Alterados lotes de IDS: ${ids.join(', ')}.`)
                        location.reload();
                        return false
                    }
                },
                error: function() {
                    alert(`Houve um erro no lote ID: ${element}.`)
                }
            });
        })
        
    } 
}



//Muda o flag de contruo via ajax
function clickConstruir(id) {
    $.ajax({
        type: "POST",
        url: "?m=lo&c=lote&a=construir",
        data: {
            id: id
        },
        success: function (json) {
            var json = JSON.parse(json);
            if (json == '1') {
                $('.tooltip').hide();
                $('#construir_' + id).html('<a onclick="clickConstruir(' + id + ')" data-toggle="tooltip" title="DESMARCAR CONSTRUO" class="btn construcao label label-success">Sim</a>');
            } else if (json == '0') {
                $('.tooltip').hide();
                $('#construir_' + id).html('<a onclick="clickConstruir(' + id + ')" data-toggle="tooltip" title="MARCAR CONSTRUO" class="btn construcao label label-danger">No</a>');
            }
        }
    });
}

function clickCaucionar(id) {
    $.ajax({
        type: "POST",
        url: "?m=lo&c=lote&a=caucionado",
        data: {
            id: id
        },
        success: function (json) {
            var json = JSON.parse(json);
            if (json == '1') {
                $('.tooltip').hide();
                $('#caucionar_' + id).html('<a onclick="clickCaucionar(' + id + ')" data-toggle="tooltip" title="DESMARCAR CAUCIONADO" class="btn fl_caucionado label label-success">Sim</a>');
            } else if (json == '0') {
                $('.tooltip').hide();
                $('#caucionar_' + id).html('<a onclick="clickCaucionar(' + id + ')" data-toggle="tooltip" title="MARCAR CAUCIONADO" class="btn fl_caucionado label label-danger">No</a>');
            }
        }
    });
}