$(document).ready(function () {    
    $('.addConta').click(function(){       
        var id_bancoVal = $('select[name=contaBanco] option').filter(':selected').val();
        var nm_banco = $('select[name=contaBanco] option').filter(':selected')[0].label;
        var nm_contaMov = $('select[name=contaMovimento] option').filter(':selected')[0].label;
        var id_finanVal = $('select[name=contaMovimento] option').filter(':selected').val();
        if (id_bancoVal && id_finanVal) {
            $.ajax({
                type: "POST",
                url: "?m=lo&c=empreendimento&a=addConta",
                data: {
                    id_banco: id_bancoVal,
                    id_finan: id_finanVal
                },
                success: function (response) {
                    if (response) {
                        $('#tbodyContas').append( '<tr id="' + id_bancoVal + '"><td>' + nm_banco + '</td><td>' + 
                        nm_contaMov + '</td><td><div align="center" style="width: 100%;">' + 
                        '<button data-toggle="tooltip" title="REMOVER" class="btn btn-default btn-xs removeConta" onclick="removeConta(' + id_bancoVal + ')" type="button" value="' + id_bancoVal + '">' +
                        '<i class="fa fa-times"></i></button></div></td></tr>' );
                    } else {
                        autohidenotify('error', 'top center', 'Impossvel adicionar.');     
                    }
                }
            });
        } else {
            autohidenotify('error', 'top center', 'Selecione corretamente as opes.');
        }
    });

    //autocomplete utilizando o plugin select2
    select2RemoteData(
        '#socios',
        true,
        true,
        'Digite o nome, cpf ou cnpj do Cliente',
        '?m=adm&c=ajax&a=findPessoasByNome'
    );

    select2RemoteData(
        '#cd_cidade',
        false,
        true,
        'Digite o nome da Cidade',
        'index.php?m=lo&c=ajax&a=findCidade'
    );

    $('#socios').on('change', function (e) {
        var ids = $(this).val();

        if (ids) {
            $('.listaItem').remove();

            $.each(ids, function (index, value) {
                $.ajax({
                    type: "POST",
                    url: "?m=lo&c=empreendimento&a=findPessoaResponsavel",
                    data: "pessoa=" + value,
                    success: function (json) {
                        var data = JSON.parse(json);
                        $.each(data, function (k, pessoa) {
                            $('#listaResponsavel').append(
                                '<li class="dd-item listaItem" id="list' + pessoa.id + '">' +
                                '<label class="dd-handle" for="assinatura' + pessoa.id + '">' +
                                pessoa.nm_pessoa +
                                '<span style="width: 60px; float: right" align="center">' +
                                '<input type="checkbox" checked name="assinaturas[]" id="assinatura' + pessoa.id + '" value="' + pessoa.id + '"></span>' +
                                '</label></li>'
                            );
                        });
                    }
                });
            });
        }
    });

    $('[name="fl_integracao"]').on("ifChecked", function (e) {
        if ($(this).val() === '0')
            $('.camposIntegraca').hide();
        else
            $('.camposIntegraca').show();
    });

    $("#periodoReajuste").on('change', function () {
        $('#porcAdc').val('0,00');
    });

    $("#indice").on('change', function () {
        if($('#indice').val() == '6') {
            $('#periodoReajuste').val('SP').trigger('change');
        } else {
            $('#periodoReajuste').val('').trigger('change');
        }

    });
    //Adiciona um indice na lista
    $('#addIndice').on('click', function() {
        if ($('#porcAdc').val() == '' || $('#porcAdc').val() == '0') {
            $('#porcAdc').val('0,00');
        }
        if (validarPeriodo()) {
            $.ajax({
                type: "POST",
                url: "index.php?m=lo&c=empreendimento&a=findIndicePeriodo",
                data: "periodo=" + $('#periodoReajuste').val()+'&indice='+$('#indice').val(),
                success: function (json) {
                    var json = JSON.parse(json),
                        linhaTabela,
                        periodoPos,
                        valorResiduo, porcAdc;
                    //Verifica se o periodo  Anual+Mensal para exibir tambm o indice de pos entrega
                    periodoPos = $('#periodoReajusteAdc').val() != ''?$('#periodoReajusteAdc').select2('data')[0].text:'';
                    porcAdc = $('#porcAdc').val() != '0,00'?$('#porcAdc').val() + '%':'';
                    json.indice = json.indice?json.indice:'';
                    json.periodo = json.periodo?json.periodo:'';
                    valorResiduo = ($('[name="calcResidio"]:checked').val() == '1')? 'Sim': 'No';
                    linhaTabela = '<tr id="indice'+$('#contador').val()+'">';
                    linhaTabela += '<td> '+json.indice+'</td>';
                    linhaTabela += '<td> '+json.periodo+'</td>';
                    linhaTabela += '<td> '+porcAdc+'</td>';
                    linhaTabela += '<td> '+periodoPos+'</td>';
                    linhaTabela += '<td>'+valorResiduo+'</td>';
                    linhaTabela += '<td><div align="center" style="width: 100%;"><button data-toggle="tooltip" title="REMOVER" class="btn btn-default btn-xs remIndice"  type="button" value="'+$('#contador').val()+'"><i class="fa fa-times"></i></button></div></td>';
                    linhaTabela += '<input type="hidden" name="listaIndices[]" class="listaIndices" value="'+$('#indice').val()+'_'+$('#periodoReajuste').val()+'_'+$('#porcAdc').val()+'_'+$('[name="calcResidio"]:checked').val()+'_'+$('#periodoReajusteAdc').val()+'" />';
                    linhaTabela += '</tr>';
                    $('#tableIndices').append(linhaTabela);
                    $('#divTabelaIndices').show();
                    $('#contador').val(parseInt($('#contador').val())+1);
                    $('.remIndice').tooltip({ trigger: "hover" });
                    $(".remIndice").unbind("click");
                    //Remover parcela da lista
                    remIndice();
                    //Reset inputs
                    $('#indice').val('').change();
                    $('#porcAdc').val('');
                    $('#periodoReajusteAdc').val('').change();
                }
            });
        } else {
            autohidenotify('error', 'top center', 'Adicione um ndice e um perodo adequado <b>e/ou</b> adicione porcentagem adicional e perodo adicional adequado.');
        }
    });
    remIndice();

    /**
     * Service para buscar remotamente o endereo
     * https://viacep.com.br/
     */
    $(".cepEmp").mask("99999-999").on('blur', function () {
        $.getJSON("//viacep.com.br/ws/" + $(this).val() + "/json/?callback=?", function (dados) {
            if (!("erro" in dados)) {
                // $("#endereco").val(dados.logradouro);
                $("#bairro").val(dados.bairro);
                // $('#cepDesconhecido').html('');
                $.ajax({
                    type: "GET",
                    url: "index.php?m=lo&c=ajax&a=find_cidade",
                    data: "term=" + removeAcento(dados.localidade)+'&uf='+dados.uf,
                    success: function (data) {
                        var obj = jQuery.parseJSON(data)[0];
                        $('#cd_cidade').html('<option value="' + obj.id + '" selected>' + obj.value + '</option>').trigger('change');
                    }
                });
            } //end if.
            else {
                //CEP pesquisado no foi encontrado.
                $(this).val(null);
                $('#cepDesconhecido').html('<a href="https://viacep.com.br/cep/" target="_blank">No encontrou o CEP?</a>');
                alert("CEP no encontrado.");
            }
        });
    });
});


function validarPeriodo() {
    if ($('#indice').val() == '' && $('#periodoReajuste').val() == '' && $('#porcAdc').val() == '0,00' && $('#periodoReajusteAdc').val() == '')
        return false;
    if ($('#indice').val() != '' && $('#periodoReajuste').val() == '')
        return false;
    if ($('#indice').val() == '' && $('#periodoReajuste').val() != '')
        return false;
    if ($('#porcAdc').val() == '0,00' && $('#periodoReajusteAdc').val() != '')
        return false;
    if ($('#porcAdc').val() != '0,00' && $('#periodoReajusteAdc').val() == '')
        return false;
    if ($('#periodoReajuste').val() == 'A' && $('#periodoReajusteAdc').val() == 'M') 
        return true;
    if ($('#periodoReajuste').val() == '' && $('#periodoReajusteAdc').val() == 'A') 
        return true;
    if ($('#periodoReajuste').val() != 'A' && $('#periodoReajusteAdc').val() == 'A') 
        return false;
    if($('#periodoReajuste').val() != ''  && $('#periodoReajusteAdc').val() !='' && $('#periodoReajuste').val() != $('#periodoReajusteAdc').val())
        return false;
    return true;
}

//Funo para change do select2 funcionar mais tranquilamente
function selectChange(select) {
}

//Funo para change do select2 funcionar mais tranquilamente
function remIndice() {
    //Remover parcela da lista
    $(".remIndice").on("click", function () {
        if($(this).val() != '') {
            $('#indice' + $(this).val()).remove();
            autohidenotify('success', 'top center', 'ndice removido com sucesso!');
            if (!$('.listaIndices')[0]) {
                $('#divTabelaIndices').hide();
            }
        } else {
            autohidenotify('error', 'top center', 'Este ndice possui contratos associados');
        }
    });
}

//Funo para rmudar o status do indice
function clickAtivo(id) {
    $.ajax({
        type: "POST",
        url: "?m=lo&c=empreendimento&a=clickAtivo",
        data: {
            id: id
        },
        success: function (json) {
            var json = JSON.parse(json);
            if (json == '1') {
                $('.tooltip').hide();
                $('#ativo_' + id).html('<a onclick="clickAtivo(' + id + ')" data-toggle="tooltip" title="INATIVAR" class="btn ativar label label-success">Ativo</a>');
            } else if (json == '0') {
                $('.tooltip').hide();
                $('#ativo_' + id).html('<a onclick="clickAtivo(' + id + ')" data-toggle="tooltip" title="ATIVAR" class="btn ativar label label-danger">Inativo</a>');
            }
        }
    });
}

//Funo para remover a conta de integrao do banco ao finan
function removeConta(id_banco){
    if (confirm('Voc deseja realmente excluir?')) {
        $.ajax({
            type: "POST",
            url: "?m=lo&c=empreendimento&a=removeConta",
            data: 'id_banco=' + id_banco,          
            success: function (response) {
                if (response) {
                    $('#' + id_banco).empty();
                } else {
                    autohidenotify('error', 'top center', 'Um erro ocorreu.');
                }
            }
        });   
    }
};