$(document).ready(function () {
    $('#pcComissao').mask('000.000.000.000.000,00', { reverse: true });
    //autocomplete utilizando o plugin select2
    select2RemoteData(
        '#idCorretor',
        false,
        true,
        'Digite o nome do Corretor',
        '?m=lo&c=corretor&a=findPessoaFisica'
    );

    select2RemoteData(
        '#imobiliaria',
        false,
        true,
        'Digite o nome da Imobili�ria',
        '?m=adm&c=ajax&a=findPessoaJuridicaByNome'
    );
    //Fun��o do para mostrar o select de porcentagem da tabela
    //Feita pelo name da div
    $("[name='tpComissao']").on('ifClicked', function () {
        if ($(this).val() == 'PT' ) {
            $(".divTabelaPreco").show("slow");
        } else {
            $(".divTabelaPreco").hide("slow");
        }
    });

    $('[name="tpComissao"]').on('ifChecked', function () {
        switch ($(this).val()) {
            case 'F':
                $('#spanValorOuDesc').html('Valor: ');
                break;
            case 'PT':
                $('#spanValorOuDesc').html('Porcentagem: ');
                break;
            case 'PL':
                $('#spanValorOuDesc').html('Porcentagem: ');
                break;
            case 'P':
                $('#spanValorOuDesc').html('Porcentagem: ');
                break;        
        }
    });

    $("#pessoas").autocomplete({
        source: "index.php?m=lo&c=ajax&a=find_pessoa",
        select: function (event, ui) {
            if (ui.item) {
                var pessoa = ui.item,
                    value = pessoa.value,
                    id = pessoa.id;

                $('#pessoas').val(value);
                $('#pessoa').val(id);
            }
            return false;
        }
    }).on('blur', function () {
        if ($(this).val() == '') {
            $('#pessoas').attr('value', '');
            $('#pessoa').attr('value', '');
        }
    });

    select2RemoteData(
        '#idCliente', //Id
        false, //Multiplo
        true, //Disabled
        'Digite o nome, cpf ou cnpj do Cliente',
        '?m=sc&c=ajax&a=findPessoasByNome'
    );

    select2RemoteData(
        '#empreendimento', //Id
        true, //Multiplo
        true, //Disabled
        'Digite o nome do Empreendimento',
        '?m=sc&c=ajax&a=findEmpreendimentoByNome'
    );
});

//Fun��o para change do select2 funcionar mais tranquilamente
function selectChange(select) {
    if (select.hasClass('corretor')) {
        $("#hcorretor").val(select.val());
    }
    if (select.hasClass('hempreendimento_corretor')) {
        $("#empreendimento").val(select.val());

        $.ajax({
            type: "POST",
            url: "index.php?m=lo&c=corretor&a=tabelaPrecoByEmpreendimento",
            data: "empreendimento=" + select.val(),
            success: function (response) {
                $("select.tbPrecos").select2({
                    'data': JSON.parse(response),
                    'placeholder': 'Tabela a Vista',
                    'allowClear': true
                });
            }
        });
    }

}


