$(document).ready(function () {
    // Esconde opo Valor Fixo, desmarca e marca
    // opo Porcentagem do campo Tipo Multa para SICREDI
    $('#idBancoConta').on('change', function () {

        var cdBanco = $(this).find(':selected').attr('cdBanco');
        $('#labelValorFixo').show();

        if (cdBanco == '748') {
            $('#tpValorMulta').prop('checked',false).iCheck('update');
            $('#tpPorcMulta').prop('checked',true).iCheck('update');
            $('#spanMulta').html('Multa');
            //$('#spanMulta%').html('(% - nica)').style.color = "red";
            $('#labelValorFixo').hide();
        }

        if (cdBanco == '274') {
            $('.jurosMensalGrafeno').show();
        } else {
            $('.jurosMensalGrafeno').hide();
        }
    });
    // Altera o texto (R$/%) do campo Multa
    // Esconde campo Multa se selecionado Sem Multa
    // Acrescenta classe que ajusta grid mantendo o campo Tipo Juros no mesmo lugar
    $('[name="tpMulta"]').on('ifChecked', function (event) {
        $('#divMulta').show();
        $('#divTpJuros').removeClass('col-sm-offset-2');
        if ($(this).val() == 'P') {
            $('#spanMulta').html('Multa: ');
            $('#spanMultaP').html('(% - nica)').style.color = "red";
        } else if($(this).val() == 'V') {
            $('#spanMulta').html('Multa: (R$)');
            $('#spanMultaP').html('');
        } else {
            $('#divMulta').hide();
            $('#divTpJuros').addClass('col-sm-offset-2');
        }
    });
    // Altera o texto (R$/%) do campo Juros
    // Esconde campo Multa se selecionado Sem Juros
    $('[name="tpJuros"]').on('ifChecked', function (event) {
        $('#divJuros').show();
        if ($(this).val() == 'P') {
            if ($('#idBancoConta').find(':selected').attr('cdBanco') == '274') {
                $('.jurosMensalSpan').html('(% - Ao ms)');
                $('.jurosMensalGrafeno').show();
            }

            $('#spanJuros').html('Juros: ');
            $('#spanJurosP').html('(% - Ao dia)').style.color = "red";
        } else if($(this).val() == 'V') {
            if ($('#idBancoConta').find(':selected').attr('cdBanco') == '274') {
                $('.jurosMensalSpan').html('(R$)');
                $('.jurosMensalGrafeno').show();
            }

            $('#spanJuros').html('Juros: (R$)');
            $('#spanJurosP').html('');
        } else {
            if ($('#idBancoConta').find(':selected').attr('cdBanco') == '274') {
                $('.jurosMensalGrafeno').hide();
            }

            $('#divJuros').hide();
        }
    });
    // Verifica se o campo Juros e Multa esto vazios, caso sim,
    // exibe mensagem de confirmao se realmente permancero vazios
    $('#btnAssociar').on('click', function (event) {
        var msg = '';

        if (($('#juros, #multa').val() == '' || $('#juros, #multa').val() <= '0') && $('[name="tpMulta"]:checked').val() == 'S' && $('[name="tpJuros"]:checked').val() == 'S') {
            msg = 'Este empreendimento est sem Multa e Juros, tem certeza que deseja continuar?';
        } else if(($('#juros').val() == '' || $('#juros').val() <= '0') && $('[name="tpJuros"]:checked').val() == 'S') {
            msg = 'Este empreendimento est sem Juros, tem certeza que deseja continuar?';
        } else if(($('#multa').val() == '' || $('#multa').val() <= '0') && $('[name="tpMulta"]:checked').val() == 'S') {
            msg = 'Este empreendimento est sem Multa, tem certeza que deseja continuar?';
        }

        if (msg != '' && !confirm(msg)) {
            event.preventDefault();
        }
    });

    // Ao criada para no fazer um submit, mas sim um verificar completamente por AJAX.
    $('#btnAssociar').on('click', function (e) {
        var $form = $('form'),
            params = $form.serializeArray(),
            formData = new FormData();

        $.each(params, function (i, val) {
            formData.append(val.name, val.value);
        });

        $.ajax({
            url: "?m=lo&c=banco&a=validarAssociar",
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            type: 'POST',
            success: function (json) {

                if (json != '') {
                    $(window).scrollTop(0);
                    json = JSON.parse(json);
                    $('.msgErros').html(json.msgErros).show();
                    setTimeout(function () {
                        $('.msgErros').slideUp();
                    }, 5000);
                } else {
                    $form.submit();
                }
            }
        })
    });

    // Ao criada para no fazer um submit, mas sim um verificar completamente por AJAX.
    $('#idBancoConta').on('change', function (e) {
        $("#idContrato").prop('disabled',true);
        $("#idContrato").html('<option value="*">Carregando Contratos...</option>');
        $('#idContrato').val('*').trigger('change');
        $.ajax({
            type: "POST",
            url: "?m=lo&c=banco&a=buscaEmpNaoAssociados",
            data: {
                idBancoConta: $(this).val()
            },
            success: function (json) {
                if (json != '') {
                    $("#idEmpreendimento").html('<option></option>');
                    $("#idEmpreendimento").prop('disabled',false);
                    $("#idEmpreendimento").select2({
                        data: JSON.parse(json),
                        allowClear: true
                    });
                } else {
                    $("#idEmpreendimento").html('<option value="*">Nenhum contrato encontrado.</option>');
                    $('#idEmpreendimento').val('*').trigger('change');
                }
            }
        })
    });

});