$(document).ready(function () {
    $(".data").on('blur', function () {
        if (validaData($(this).val())) {
            $(this).val(null);
        }
    });
    $("#id_taxa").on('change', function () {
        if ($(this).val() != '' && $(this).val() != '*') {
            $.ajax({
                type: "POST",
                url: "?m=fin&c=recibo&a=findTaxa",
                data: "idTaxa="+$(this).val(),
                success: function (response) {
                    var json = JSON.parse(response);
                    if (json) {
                        $("#vl_taxa").val(float2moeda(json.vl_taxa));
                    }
                }
            });
        }
    });

    $("#vlDescontoTaxas").blur(function () {
        var vlDesconto = moeda2float($(this).val()),
            vlTaxa = moeda2float($('#vl_taxa').val());
        if (vlDesconto != "" && vlTaxa != 0) {
            if (vlDesconto > vlTaxa) {
                alert('O valor do desconto no pode ser maior que o valor do ttulo.');
                vlDesconto.val(null);
            }
            if (vlDesconto < 0) {
                alert('O valor do desconto no pode ser nmero negativo.');
                vlTaxa.val(null);
            }
        }
    });
});
//Funo para change do select2 funcionar mais tranquilamente
function selectChange(select) {
    if (select.hasClass('idEmpreendimentoRecibo')) {
        $(".id_taxa, .cliente").prop('disabled', true);
        $(".id_taxa, .cliente").html('<option value="*">Carregando...</option>');
        $(".id_taxa, .cliente").val('*').trigger('change');
        $.ajax({
            type: "POST",
            url: "?m=fin&c=recibo&a=taxaEmpreendimento",
            data: "idEmpreendimento=" + select.val(),
            success: function (response) {
                var json = JSON.parse(response);
                if(json != '') {
                    $("select.id_taxa").html('<option value="">Selecione ...</option>');
                    $(".id_taxa").prop('disabled',false);
                    $("select.id_taxa").select2({
                        'data': json,
                        'placeholder': 'Escolha a Taxa',
                        'allowClear': true
                    });
                } else {
                    $(".id_taxa").html('<option value="*">Nenhuma taxa Cadastrada.</option>');
                    $(".id_taxa").val('*').trigger('change');
                }
            }
        });
        $.ajax({
            type: "POST",
            url: "?m=fin&c=recibo&a=clienteEmpreendimento",
            data: "idEmpreendimento=" + select.val(),
            success: function (response) {
                var json = JSON.parse(response);
                if(json != '') {
                    $("select.cliente").html('<option value="">Selecione ...</option>');
                    $(".cliente").prop('disabled',false);
                    $("select.cliente").select2({
                        'data': json,
                        'placeholder': 'Escolha o Cliente',
                        'allowClear': true
                    });
                } else {
                    $(".cliente").html('<option value="*">Nenhum Contrato Cadastrado.</option>');
                    $(".cliente").val('*').trigger('change');
                }
            }
        });
    }
}
