$(document).ready(function () {

    $('[name="tpReajuste"]').on('ifChecked', function (event) {
        if ($(this).val() == 'M') {
            $('#divContrato').show();
            $('#divIndice').hide();
            $('#divReajusteFora').show();
        } else {
            $('#divIndice').show();
            $('#divContrato').hide();
            $('#divReajusteFora').hide();
        }
    });

    $('select').change(function () {
        liberarInputReajusteForaPrazo();
    });

    $('#anoInicial').keyup(function () {
        liberarInputReajusteForaPrazo();
    });

    $('#reajusteFora').on('ifChanged', function (event) {
        if (event.target.checked) {
            $('#btnSalvar').attr('onClick', 'event.preventDefault();submitResult();');
            $('#divAtencao').show();
            consultaDataReajusteForaPrazo();
        } else {
            $('#btnSalvar').removeAttr('onClick');
            $('#divAtencao').hide();
        }
    });
});

function liberarInputReajusteForaPrazo() {
    if ($('#idEmpreendimento').val() &&
        $('#idContrato').val() &&
        $('#mesInicial').val() &&
        $('#anoInicial').val()) {
        $('#reajusteFora').iCheck('enable');
    } else {
        $('#reajusteFora').iCheck('disabled');
    }
}

function consultaDataReajusteForaPrazo() {
    $.ajax({
        method: 'POST',
        url: '?m=fin&c=reajuste&a=reajuste',
        data: $("#form").serialize(),
        success: function (data) {
            $('#dataReajusteForaPrazo').text('');
            if (data.includes("result")) {
                data = JSON.parse(data);
                $('#dataReajusteForaPrazo').text(`Reajuste fora da programao. O prximo reajuste deveria ser em ${data.result}, deseja avanar?`);
            } else {
                $('#dataReajusteForaPrazo').text('Impossvel realizar o reajuste fora do perodo com este ano, pois no h parcelas disponveis.');
            }
        }
    });
}

function submitResult() {
    if (confirm($('#dataReajusteForaPrazo').text())) {
        $.ajax({
            url: '?m=fin&c=reajuste&a=reajusteForaDoPrazo',
            success: function (data) {
                console.log(data);
                if (data.includes("permissionFound")) {
                    $('#form').append(
                        $('<input>')
                            .attr('type', 'hidden')
                            .attr('name', 'acceptReajusteFora')
                            .val(true)
                    ).submit();
                } else {
                    alert("O usurio no tem permisso para reajustar fora do prazo.");
                    window.location = "?m=fin&c=reajuste&a=listar";
                }
            }
        })
    }
}

function selectChange(select) {
    if (select.hasClass('idEmpreendimentoReajuste')) {
        $("#idContrato").html('<option value=""></option>');
        $("#idIndice").html('<option value=""></option>');
        $.ajax({
            type: "POST",
            url: "?m=fin&c=reajuste&a=contratoReajusteParcelas",
            data: "id_empreendimento=" + select.val(),
            success: function (response) {
                $("#idContrato").select2({
                    'data': JSON.parse(response),
                    'placeholder': 'Escolha o Contrato',
                    'allowClear': false
                });
            }
        });
        $.ajax({
            type: "POST",
            url: "index.php?m=fin&c=reajuste&a=getIndiceEmpreendimento",
            data: "idEmpreendimento=" + select.val(),
            success: function (json) {
                $('#idIndice').attr('disabled', false);
                $('#idIndice').select2({
                    'data': JSON.parse(json),
                    'placeholder': 'Escolha o ndice',
                    'allowClear': true
                });
            }
        });
    }
}

