$(document).ready(function () {
    /**
     * Listar
     *
     */
    var table = $('#TabelaListar').dataTable({
        ajax: {
            url: "?m=fin&c=reajuste&a=listar",
            type: 'POST',
        },
        responsive: true,
        processing: true,
        serverSide: true,
        destroy: true,
        orderCellsTop: true,
        lengthMenu: [[10, 25, 50, 100], [10, 25, 50,100]],
        "columns": [
            {"data": 'checkbox'},
            {"data": 'contrato'},
            {"data": 'empreendimento'},
            {"data": 'pessoa'},
            {"data": 'quadra'},
            {"data": 'lote'},
            {"data": 'reajuste'},
            {"data": 'tipo'},
            {"data": 'indice'},
            {"data": 'indiceAdc'},
            {"data": 'residuo'},
            {"data": 'porcIndice'},
            {"data": 'usuario'},
            {"data": 'acao'}
        ],

        //Define a coluna default que ser� ordenada quando abrir a p�gina
        "order": [[0, "desc"]],

        "columnDefs": [
        {
            "type": "date-eu",
            "targets": 6            
        }
     ],

        //Organiza os botoes, paginao, campos e notifica��es
        dom: 'lfrtip',

        //Define as op��es de quantidade de linhas que aparec�o na lista
        "lengthMenu": [[10, 25, 50], [10, 25, 50]],

        //Pensonalizando as mensagens que por default s�o em ingl�s e formatao de valores
        language: {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "",
            "sInfoEmpty": "",
            "sInfoFiltered": "",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Busca",
            "oPaginate": {
                "sNext": "Prximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "ltimo"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            },

            "decimal": ",",
            "thousands": "."
        }
    });

    // Busca Avanada
    $('#TabelaListar thead tr:eq(1) th').each(function (i) {
        title = $(this).text();
        if (title == 'Contrato' || title == 'Empreendimento' || title == 'Quadra' || title == 'Lote' || 
            title == 'Cliente' || title == 'ndice / Perodo') {
            var search = '<input hide type="text" class="form-control input-sm" style="width:100%" placeholder="' + title + '" />';            
        } 
        else if (title == 'Reajuste' ) {
            var search = '<input hide type="date" class="form-control input-sm" style="width:100%" placeholder="' + title + '" />';            
        } else {
            var search = '';
        }
        $(this).html('');
        // Apply the filter
        $(search).appendTo(this).on('change',function(){table.fnFilter($(this).val(),i)})
    });

    $('thead tr').last().hide()
    $('.dataTables_filter').after('<a href="#" class="btn btn-sm btn-default" onClick="hide()">Busca Avanada</a>'); 
    
    telaCarregando();
});

function hide() {
    $('thead tr').last().toggle('1000');
}

function checkBox(){
    $('#btnDesfazer').attr('disabled', false);
}

function delCheckbox() {
    var reajustesSuccess = [];
    var reajustesFails = [];
    var count = $("input:checkbox[id=checkDesfazer]:checked").length;

    $("input:checkbox[id=checkDesfazer]:checked").each(function(index){
        var checkbox = $(this);
        $.when(
            $.ajax({
                type: "POST",
                url: "?m=fin&c=reajuste&a=delReajuste",
                dataType: "json",
                data: { id: $(this).val() },
                beforeSend: function () {
                    $('.loadingPage').removeClass('hidden');
                }
            })
        ).then(function (data) {

            switch (data) {
                case "pagoRemessa":                    
                    reajustesFails.push( checkbox.val() );
                    break;
                case true:
                    reajustesSuccess.push( checkbox.val() );
                    break;
                case false:
                    alert("No foi possvel realizar esta ao.");
                    break;
                default:
                    alert("Algum erro ocorreu.");
                    break;
            }
            if (index+1 === count) {
                if (reajustesFails.length && reajustesSuccess.length) {
                    alert('Reajustes ' + reajustesFails + '  desfeito de forma parcial, pois existem contratos com parcelas pagas e/ou enviadas remessas que nao foram possveis de desfazer o reajuste. Reajustes '+ reajustesSuccess + ' desfeitos com sucesso.');
                } else if (reajustesSuccess.length) {
                    alert('Reajustes '+ reajustesSuccess + ' desfeitos com sucesso.');
                } else if (reajustesFails.length) {
                    alert('Reajustes ' + reajustesFails + ' desfeito de forma parcial, pois existem contratos com parcelas pagas e/ou enviadas remessas que nao foram possveis de desfazer o reajuste.');
                }
                window.location.reload();
            }
        });
        
    }); 
}

function delReajuste(id, varios = null) {    

    var idRea = id.toString();

    var entrada = varios ? true : confirm("Deseja continuar a realizar o reajuste " + idRea + "?")

    if (entrada) {
        $.ajax({
            type: "POST",
            url: "?m=fin&c=reajuste&a=delReajuste",
            data: {id: idRea},            
            dataType: "json",
            beforeSend: function () {
                $('.loadingPage').removeClass('hidden');
            },
            success: function (response) {
                if (!varios)
                    window.location.reload()

                switch (response) {
                    case 'acessoNegado':
                        return alert('Voc no tem permisso para acessar essa funcionalidade.');
                    case "pagoRemessa":                         
                        return ((!varios) ? alert('Reajuste '+ idRea + ' desfeito de forma parcial. Ateno! Existem contratos com parcelas pagas e/ou enviadas remessas que no foram possveis de desfazer o reajuste.') : 'fail');                 
                    case true:
                        return ((!varios) ? alert('Reajuste '+ idRea + ' desfeito com sucesso.') :  'success');
                    case false:
                        return alert("No foi possvel realizar esta ao.");
                    default:
                        return alert("Algum erro ocorreu.");
                }
            },
            error: function(xhr, status, err){
                return alert("Voc no tem permisso para realizar esta ao.");
            }            
        });
    }

    return null;
}

function telaCarregando() {
    var conteudo ='<div class="loadingPage hidden" style="width: 100%; height: 100%;z-index: 999999999;background-color: rgba(255,255,255,0.5);position: fixed;">';
    conteudo += '<div style="position: absolute;top: 40%;left: 50%;margin-right: -50%;">';
    conteudo += '<svg width="64px" height="64px" viewBox="0 0 128 128" xml:space="preserve"><rect x="0" y="0" width="100%" height="100%" fill-opacity="0"/><g><circle cx="16" cy="64" r="16" fill="#FFFFFF" fill-opacity="1"/><circle cx="16" cy="64" r="16" fill="#555555" fill-opacity="0.5" transform="rotate(45,64,64)"/><circle cx="16" cy="64" r="16" fill="#949494" fill-opacity="0.5" transform="rotate(90,64,64)"/><circle cx="16" cy="64" r="16" fill="#cccccc" fill-opacity="0.2" transform="rotate(135,64,64)"/><circle cx="16" cy="64" r="16" fill="#e1e1e1" fill-opacity="0.12" transform="rotate(180,64,64)"/><circle cx="16" cy="64" r="16" fill="#e1e1e1" fill-opacity="0.12" transform="rotate(225,64,64)"/><circle cx="16" cy="64" r="16" fill="#e1e1e1" fill-opacity="0.12" transform="rotate(270,64,64)"/><circle cx="16" cy="64" r="16" fill="#e1e1e1" fill-opacity="0.12" transform="rotate(315,64,64)"/><animateTransform attributeName="transform" type="rotate" values="0 64 64;315 64 64;270 64 64;225 64 64;180 64 64;135 64 64;90 64 64;45 64 64" calcMode="discrete" dur="720ms" repeatCount="indefinite"></animateTransform></g></svg>';
    conteudo += '</div></div>';

    $('body').before(conteudo);
}