$(document).ready(function () {
    $('#id_contrato').change(function (e) { 
        $('#campo').empty();
        e.preventDefault();        
        $.ajax({
            type: "POST",
            url: "?m=fin&c=quitacao&a=getObsQuitacao",
            data: "contrato=" + $(this).val(),
            success: function (response) {
                var data = JSON.parse(response);
                if (data.obsqui) {
                    $('#campo').empty();
                    $('#campo').append(data.obsqui);
                }
            }
        });        
    });
    //exibe e esconde os campos em gerar contrato
    $('[name="tipoImpressao"]').on('ifChecked', function () {

        switch ($(this).val()) {
            case 'P':
                $('#btnPdf').show();
                $('#btnWord').hide();
                $('#divArquivoWord').hide();
                $('#divArquivoWord2').hide();
                break;
            case 'A':
                $('#btnPdf').hide();
                $('#btnWord').show();
                $('#divArquivoWord').show();
                $('#divArquivoWord2').show();
                break;
        }
    });
    //Funo para no abrir outra aba quando no tiver resultados
    $('#word').on('click', function (e) {
        $('form').attr('action', '?m=fin&c=quitacao&a=gerarWord');
    });
    $('#gerar').on('click', function (e) {
        $('form').attr('action', '?m=fin&c=quitacao&a=termoDeQuitacao');
    });

    /**
     * QUITAO
     */
    $(".data").on('blur', function () {
        if (validaData($(this).val())) {
            $(this).val(null);
        }
    });
});
function selectChange(select) {
    if (select.hasClass('empreendimentoQuitacao')) {
        var empreendimento = select.val();
        $("#id_contrato").prop('disabled', false);
        $("#id_contrato").empty();
        $.ajax({
            type: "POST",
            url: "?m=fin&c=quitacao&a=lote_quitacao_by_empreendimento",
            data: "id_empreendimento=" + select.val(),
            success: function (response) {
                var json = JSON.parse(response);
                if (json) {
                    $("#id_contrato").prop('disabled', false);
                    $("#id_contrato").select2({
                        'data': json,
                        'placeholder': 'Escolha o Contrato',
                        'allowClear': true,
                        'language': {
                            "noResults": function () {
                                return "Nenhum resultado encontrado";
                            },
                            "searching": function () {
                                return "Pesquisando...";
                            }
                        }
                    });
                }
            }
        });
    }
}


