$(document).ready(function () {
    $('#TabelaListar').DataTable({
        "processing": true,
        "autoWidth": true,
        "ajax": $('#TabelaListar').dataTable.pipeline({
            "url": "?m=fin&c=quitacao&a=gerarLista",
            type: 'POST',
        }),
        "columns": [
            {"data": 'id'},
            {"data": 'empreendimento'},
            {"data": 'contrato'},
            {"data": 'pessoa'},
            {"data": 'quadra'},
            {"data": 'lote'},
            {"data": 'data'},
            {"data": 'dataBase'},
            {"data": 'acoes'}
        ],

        "order": [[0, "desc"]],

        "columnDefs": [
            {
                "orderable": false,
                "targets": -1,
                "searchable": false,
                "width": "140px",
            },
            { "targets": -3, "width": "100px" },
            { "targets": -2, "width": "160px" }

        ],

        //Organiza os botoes, paginao, campos e notificaes
        dom: '<"btnAdicionar">, lfrtip',

        //Define as opes de quantidade de linhas que apareco na lista
        "lengthMenu": [[10, 25, 50], [10, 25, 50]],

        //Pensonalizando as mensagens que por default so em ingls e formatao de valores
        language: {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "",
            "sInfoEmpty": "",
            "sInfoFiltered": "",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Busca",
            "oPaginate": {
                "sNext": "Prximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "ltimo"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            },
            "decimal": ",",
            "thousands": "."
        }
    });
});