$(document).ready(function () {
    $(".migradasPac").on('ckeck', function () {
        $('#migradas').val($(this).attr('migradas'));
        limpaCampos();
    });

    $('#nrParcela').blur(function () {
        if($(this).val() != '') {
            var nrParcela = $('#nrParcela').val();
            $('#nrParcela').prop('disabled',true);
            $('#nrParcela').val('Pesquisando...');
            $('#situacao').val(null);
            $.ajax({
                type: "POST",
                url: "?m=fin&c=pesquisaTitulo&a=pesquisaTitulo",
                data: {
                    numero: nrParcela,
                    migradas: $('[name="migradas"]:checked').val()
                },
                dataType: "json",
                success: function (response) {
                    $('#nrParcela').prop('disabled',false);
                    $('#nrParcela').val(nrParcela);

                    if (response == '') {
                        limpaCampos();
                        $('#situacao').val('Titulo No Encontrado!');
                    } else if (response.length > 1) {
                        var html = "";
                        for (var i in response) {
                            console.log(response);
                            html = html +
                                "<legend>"+
                                    "<div class='tituloEmp' style='cursor: pointer; font-size: 17px;'>"+
                                        response[i].empreendimento +
                                    "</div>"+
                                "</legend>"+
                                "<div id='pesquisaMultipla'>"+
                                    "<div class='row'>"+
                                        "<div class='col-sm-12'>"+
                                            "<div class='form-group col-sm-4'>"+
                                                "<label class='control-label'> Nmero:</label>"+
                                                "<input type='text' class='form-control' value='"+response[i].numero+"' disabled='disabled'>"+
                                            "</div>"+
                                            "<div class='form-group col-sm-4'>"+
                                                "<label class='control-label'> Situao:</label>"+
                                                "<input type='text' class='form-control' value='"+response[i].situacao+"' disabled='disabled'>"+
                                            "</div>"+
                                        "</div>"+

                                        "<div class='col-sm-12'>"+
                                            "<div class='form-group col-sm-6'>"+
                                                "<label class='control-label'> Empreendimento:</label>"+
                                                "<input type='text' class='form-control' value='"+response[i].empreendimento+"' disabled='disabled'>"+
                                            "</div>"+
                                            "<div class='form-group col-sm-6'>"+
                                                "<label class='control-label'> Cliente:</label>"+
                                                "<input type='text' class='form-control' value='"+response[i].cliente+"' disabled='disabled'>"+
                                            "</div>"+
                                        "</div>"+
                                    "</div>"+

                                    "<div class='row'>"+
                                        "<div class='col-sm-12'>"+
                                            "<div class='form-group col-sm-2'>"+
                                                "<label class='control-label'> Parcela:</label>"+
                                                "<input type='text' class='form-control' value='"+response[i].parcela+"' disabled='disabled'>"+
                                            "</div>"+
                                            "<div class='form-group col-sm-2'>"+
                                                "<label class='control-label'> Valor:</label>"+
                                                "<input type='text' class='form-control' value='"+response[i].valor+"' disabled='disabled'>"+
                                            "</div>"+
                                            "<div class='form-group col-sm-2'>"+
                                                "<label class='control-label'> Data:</label>"+
                                                "<input type='text' class='form-control' value='"+response[i].data+"' disabled='disabled'>"+
                                            "</div>"+
                                            "<div class='form-group col-sm-2'>"+
                                                "<label class='control-label'> Quadra:</label>"+
                                                "<input type='text' class='form-control' value='"+response[i].quadra+"' disabled='disabled'>"+
                                            "</div>"+
                                            "<div class='form-group col-sm-2'>"+
                                                "<label class='control-label'> Lote:</label>"+
                                                "<input type='text' class='form-control' value='"+response[i].lote+"' disabled='disabled'>"+
                                            "</div>"+
                                            "<div class='form-group col-sm-2'>"+
                                                "<label class='control-label'> Contrato:</label>"+
                                                "<input type='text' class='form-control' value='"+response[i].num_contrato+"' disabled='disabled'>"+
                                            "</div>"+
                                        "</div>"+
                                    "</div>"+

                                    "<div class='row'>"+
                                        "<div class='col-sm-12'>"+
                                            "<div class='form-group col-sm-2'>"+
                                                "<label class='control-label'> Banco:</label>"+
                                                "<input type='text' class='form-control' value='"+response[i].nm_banco+"' disabled='disabled'>"+
                                            "</div>"+
                                            "<div class='form-group col-sm-2'>"+
                                                "<label class='control-label'> Conta:</label>"+
                                                "<input type='text' class='form-control' value='"+response[i].conta+"' disabled='disabled'>"+
                                            "</div>"+
                                            "<div class='form-group col-sm-2'>"+
                                                "<label class='control-label'> Agncia:</label>"+
                                                "<input type='text' class='form-control' value='"+response[i].agencia+"' disabled='disabled'>"+
                                            "</div>"+
                                        "</div>"+
                                    "</div>"+
                                "</div>";
                            
                            $(".divPesquisaTituloMulti").show("slow");
                            $("#divSituacao").hide("slow");
                            $("#divEmpCliente").hide("slow");
                            $("#rowPadrao").hide("slow");
                            
                        }
                        $(".divPesquisaTituloMulti")[0].innerHTML=html;
                    } else {
                        $(".divPesquisaTituloMulti").hide("slow");
                        $("#divSituacao").show("slow");
                        $("#divEmpCliente").show("slow");
                        $("#rowPadrao").show("slow");

                        $('#situacao').val(" " + response[0].situacao);
                        $('#empreendimento').val(" " + response[0].empreendimento);
                        $("#cliente").val(" " + response[0].cliente);
                        $("#lote").val(" " + response[0].lote);
                        $("#quadra").val(" " + response[0].quadra);
                        $("#num_contrato").val(" " + response[0].num_contrato);
                        $("#num_parcela").val(" " + response[0].parcela);
                        $("#data").val(" " + response[0].data);
                        $("#valor").val(" R$ " + float2moeda(response[0].valor));
                    }
                }
            });
        } else {
            limpaCampos();
        }
    });
});

function limpaCampos() {

    $('#situacao').val(null);
    $('#empreendimento').val(null);
    $("#cliente").val(null);
    $("#lote").val(null);
    $("#quadra").val(null);
    $("#num_contrato").val(null);
    $("#num_parcela").val(null);
    $("#data").val(null);
    $("#valor").val(null);
}