$(document).ready(function () {
    $('#btnExcluir').prop('disabled', true);
});

function selectChange (select) 
{
    if (select.hasClass('empreendimentoExcluirAvulsa'))
    {
        $('select.contratoExcluirAvulsa').html('<option value=""></option>');

        $.ajax({
            type: 'POST',
            url: 'index.php?m=fin&c=parcelaAvulsaExclusao&a=buscarContratoPorEmpreendimento',
            data: {
                id_empreendimento: $('#idEmpreendimento').val()
            },
            success: function(response)
            {
                var json = JSON.parse(response);
                
                if (json)
                {
                    $('select.contratoExcluirAvulsa').prop('disabled', false);
                    $('select.contratoExcluirAvulsa').select2({
                        'data': json,
                        'placeholder': 'Selecione o Contrato',
                        'allowClear': true
                    });
                } else {
                    $(window).scrollTop(0);
                    $('.msgErros').html('Este empreendimento no possui contratos com parcelas avulsas.').show();

                    setTimeout(function (){
                        $('.msgErros').slideUp();
                    }, 5000);
                }
            }
        });
    }

    if (select.hasClass('contratoExcluirAvulsa'))
    {
        $('select.parcelaExcluirAvulsa').html('<option value=""></option>');
        $.ajax({
            type: 'POST',
            url: 'index.php?m=fin&c=parcelaAvulsaExclusao&a=parcelaAvulsaByContrato',
            data: {
                idContrato: $('#idContrato').val()
            },
            success: function(response)
            {
                var json = JSON.parse(response);
                
                if (json)
                {
                    $('select.parcelaExcluirAvulsa').prop('disabled', false);
                    $('select.parcelaExcluirAvulsa').select2({
                        'data': json,
                        'placeholder': 'Selecione a Parcela',
                        'allowClear': true
                    });
                }
            }
        });
    }

    if (select.hasClass('parcelaExcluirAvulsa'))
    {
        $('#btnExcluir').prop('disabled', false);
    }
}

function myFunction ()
{
    if (confirm('Tem certeza que deseja remover essa parcela?'))
    {
        $.ajax({
            type: 'POST',
            url: 'index.php?m=fin&c=parcelaAvulsaExclusao&a=remover',
            data: {
                idParcelaAvulsa: $('#idParcela').val()
            },
            success: function (response)
            {
                if (response)
                {
                    $(window).scrollTop(0);

                    $('.msgSuccess').html('Parcela Avulsa excluda com sucesso!').show();
                    setTimeout(function (){
                        $('.msgSuccess').slideUp();
                    }, 7000);

                    //reseta os campos select, fazendo com que os mesmos recebam o valor default
                    $('#idEmpreendimento').val(null);
                    $('#idContrato').val(null).trigger('change');
                    $('#idParcela').val(null).trigger('change');
                } else {
                    $(window).scrollTop(0);

                    $('.msgErros').html('No foi possvel remover essa parcela, por favor contate o suporte.').show();
                    setTimeout(function (){
                        $('.msgErros').slideUp();
                    }, 5000);
                }
            }
        });
    } 
}