$(document).ready(function () {
    //PASSO 4
    $('#TabelaListarPasso4').DataTable({
        "processing": true,

        //Define a coluna default que ser ordenada quando abrir a pgina
        "order": [[0, "asc"]],

        //Organiza os botoes, paginao, campos e notificaes
        dom: '<"btnAdicionar">lfrtip',

        "pageLength": -1,
        "bLengthChange": false,
        "bFilter": false,
        "paging": false,

        //Define as colunas que no tero ordenao
        "columnDefs": [
            {
                "orderable": false,
                "targets": 0,
                "searchable": false
            },
            {
                "orderable": false,
                "targets": -1,
                "searchable": false
            },
            {
                "className":"dt-center",
                "targets": "_all"
            }
        ],

        //Pensonalizando as mensagens que por default so em ingls e formatao de valores
        language: {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "",
            "sInfoEmpty": "",
            "sInfoFiltered": "",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Busca",
            "oPaginate": {
                "sNext": "Prximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "ltimo"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            },

            "decimal": ",",
            "thousands": "."
        }
    });

    //Funo para calcular o valor das parcelas ao inserir porcentagem
    function calcularParcelas() {
        
        var total = moeda2float($('#totalGeral').val()),
             porcentagens = [],
             valores = [],
             soma = 0;
             
        $('.integer').each(function (index) {
         
            var porcent = $(this).val();
            porcent = Number(porcent);
            
            if ($('#porcentagem').val() && ($('#porcentagem').val() > 0) && ($('#porcentagem').val() <= 100)) {
            
                porcentagens.push(porcent);
                soma += porcent;
                
            } else {
                porcentagens.push(0);
            }
        });
        
        if (soma != 0 && soma <= 100) {

            porcentagens.forEach(function (porcent, index) {
            
                var valor = (total / 100) * porcent;
                valores.push(valor);
                var input_parcela = $('input[name="valor[]"]').eq(index);
                input_parcela.val(float2moeda(valor));
            });
        } else {
            alert("Para um calculo correto a soma da porcentagem deve ficar entre 1 e 100!");
        }

       //Funo para  calcular o valor restante e e dividir entre as paracelas que no tem porcentagem informada
        var valorPreenchido = 0,
            numeroPreenchido = 0;
    
        $('.integer').each(function(index, el) {

            var porcent = parseFloat($(el).val());

            if (!isNaN(porcent)){    
            
                if ($('#porcentagem').val() && ($('#porcentagem').val() > 0)) {
                
                var parcela = (total / 100) * porcent;
                valorPreenchido += parcela;
                numeroPreenchido++;
                
                }
            }
        });
    
        var valorRestante = total - valorPreenchido,
            numeroRestante = $('.integer').length - numeroPreenchido;
        if (numeroRestante > 0) {
        
            var valorMedio = float2moeda(valorRestante / numeroRestante);
        
            $('.integer').each(function(index, e) {
            
                var porcent = parseFloat($(e).val());
            
                if (isNaN(porcent) || porcent == 0) {
            
                    $('input[name="valor[]"]').eq(index).val(valorMedio);
            
                    valorRestante -= valorMedio;
                    numeroRestante--;
                }
        
            });
        }
    }

    $(document).ready(function () {
    
        $('.integer').on("change", function () {
            calcularParcelas();
        });
    });

    //Funo para recalcular o valor restante e dividir entre as outras parcelas igualmente
    $('.money').on('blur',function () {

        var totalGeral = moeda2float($('#totalGeral').val()),
            totalAtual = 0,
            vlDesconto = moeda2float($('#desconto').val()),
            vlAcrescimo = moeda2float($('#acrescimo').val());

        $("#desconto, #acrescimo").html('');
        $(".desconto, .acrescimo").val('');

        $('.money').each(function () {
            totalAtual += moeda2float($(this).val());
        });
        //Somando os valores digitados nas parcelas para exibir a diferena no Desconto(se for menor que o total)
        if (totalAtual < totalGeral) {
            vlDesconto = totalGeral - totalAtual;
            $("#desconto").html('<strong> R$ ' + float2moeda(vlDesconto) + '</strong>');
            $(".desconto").val(vlDesconto);
        }
        //Somando os valores digitados nas parcelas para exibir a diferena no Acrescimo(se for maior que o total)
        else if (totalAtual > totalGeral) {
            vlAcrescimo = totalAtual - totalGeral;
            $("#acrescimo").html('<strong> R$ ' + float2moeda(vlAcrescimo) + '</strong>');
            $(".acrescimo").val(vlAcrescimo);
        }
    });
});