$(document).ready(function () {
    updateTotals();

    $('.money').on('change', function() {
        updateTotals();
    });
    
    //PASSO 3
    $('#TabelaListarPasso3').DataTable({
        "processing": true,

        //Define a coluna default que ser ordenada quando abrir a pgina
        "order": [[0, "asc"]],

        //Organiza os botoes, paginao, campos e notificaes
        dom: '<"btnAdicionar">lfrtip',

        "pageLength": -1,
        "bLengthChange": false,
        "bFilter": false,
        "paging": false,

        //Define as colunas que no tero ordenao
        "columnDefs": [
            {
                "orderable": false,
                "targets": 0,
                "searchable": false
            },
            {
                "orderable": false,
                "targets": -1,
                "searchable": false
            },
            {
                "className":"dt-center",
                "targets": "_all"
            }
        ],

        //Pensonalizando as mensagens que por default so em ingls e formatao de valores
        language: {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "",
            "sInfoEmpty": "",
            "sInfoFiltered": "",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Busca",
            "oPaginate": {
                "sNext": "Prximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "ltimo"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            },

            "decimal": ",",
            "thousands": "."
        },
    });

    //Funo para gerar calculo
    //Trocado de um boto para calculo por preenchimento!
    function updateTotals() {
        var parcela = $('#parcelas').val().split(':');
        var total = 0;
    
        for (var i = 0; i < parcela.length; i++) {
            var totalp = 0;
            var desconto = 0;
            var acrescimo = 0;
    
            if ($('#total_' + parcela[i]).val() != '') {
                var vlr = $('#total_' + parcela[i]).val().replace('.', '');
                totalp = parseFloat(vlr.replace(',', '.'));
            }
    
            if ($('#desconto_' + parcela[i]).val() != '') {
                var descontoAntigo = $('#descontoAntigo_' + parcela[i]).val().replace('.', '');
                descontoAntigo = parseFloat(descontoAntigo.replace(',', '.'));
    
                vlr = $('#desconto_' + parcela[i]).val().replace('.', '');
                desconto = parseFloat(vlr.replace(',', '.'));
                desconto == descontoAntigo;
    
                if (desconto > 0) {
                    desconto = parseFloat(desconto.toFixed(2));
                }
            }
    
            if ($('#acrescimo_' + parcela[i]).val() != '') {
                var acrescimoAntigo = $('#acrescimoAntigo_' + parcela[i]).val().replace('.', '');
                acrescimoAntigo = parseFloat(acrescimoAntigo.replace(',', '.'));
    
                vlr = $('#acrescimo_' + parcela[i]).val().replace('.', '');
                acrescimo = parseFloat(vlr.replace(',', '.'));
                acrescimo == acrescimoAntigo;
    
                if (acrescimo > 0) {
                    acrescimo = parseFloat(acrescimo.toFixed(2));
                }
            }
    
            var total2 = totalp + acrescimo - desconto;
            $('#tdTotal_' + parcela[i]).html(float2moeda(total2));
            total += total2;
        }
    
        $('#total').html('R$ ' + float2moeda(total));
        $('#hidden_total').val(float2moeda(total));
    }
});