$(document).ready(function () {
    $('#doGerarSintetico').hide();
    $('#TabelaListar').DataTable({
        "processing": true,
        "serverSide": false,
        "autoWidth": true,
        "ajax": $('#TabelaListar').dataTable.pipeline({
            "url": "index.php?m=fin&c=negociacao&a=listar",
            "pages": 5
        }),
        "columns": [
            {"data": 'codigo'},
            {"data": 'empreendimento'},
            {"data": 'quadra'},
            {"data": 'lote'},
            {"data": 'contrato'},
            {"data": 'cliente'},
            {"data": 'tipo'},
            {"data": 'data'},
            {"data": 'dt_calculo'},
            {"data": 'acoes'}
        ],

        //Define a coluna default que ser� ordenada quando abrir a p�gina
        "order": [0, "desc"],

        //Organiza os botoes, pagina��o, campos e notifica��es
        dom: '<"btnGerar"><"btnAdicionar">lfrtip',

        //Define as op��es de quantidade de linhas que aparec�o na lista
        "lengthMenu": [[10, 25, 50], [10, 25, 50]],

        //Define as colunas que n�o ter�o ordena��o
        "columnDefs": [
            {
                "orderable": false,
                "targets": -1,
                "searchable": false
            },
            {
                "className":"dt-center",
                "targets": [0,2,3,4,5,6]
            }
        ],

        //Pensonalizando as mensagens que por default s�o em ingl�s e formata��o de valores
        language: {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "",
            "sInfoEmpty": "",
            "sInfoFiltered": "",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Busca",
            "oPaginate": {
                "sNext": "Próximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "Último"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            },

            "decimal": ",",
            "thousands": "."
        }
    });
    //Bot�o Adicionar de Negocia��o
    var btnAdicionar = '<a class="btn btn-success" href="?m=fin&c=negociacao&a=adicionar"><i class="fa fa-plus-circle">&nbsp;</i>Adicionar</a>';
    $("div.btnAdicionar").html(btnAdicionar);

});
function gerarPago(id) {
    $('#idNegociacao').val(id);

    $('[name="modalTipoEmissao"]').on('ifChecked', function () {
        switch ($(this).val()) {
            case 'A':
                $('#doGerarAnalitico').show();
                $('#doGerarSintetico').hide();
                break;
            case 'S':
                $('#doGerarAnalitico').hide();
                $('#doGerarSintetico').show();
                break;
        }
    });
}


$('#doGerarAnalitico').on('click', function (e) {
    var tpArquivo = $("input[name='modalTpArquivo']:checked").val(),
    idNegociacao = $('#idNegociacao').val();
    
    window.open('index.php?m=fin&c=negociacao&a=emitir&id='+ idNegociacao +'&tp='+ tpArquivo, '_blank');
        
});
$('#doGerarSintetico').on('click', function (e) {
    var tpArquivo = $("input[name='modalTpArquivo']:checked").val(),
    idNegociacao = $('#idNegociacao').val();
    
    window.open('index.php?m=fin&c=negociacao&a=gerarRelatorio&id='+ idNegociacao +'&tp='+ tpArquivo, '_blank');
        
});
