$(document).ready(function () {
    $('.flTipo').on('click', function () {
        $("#flOpcao").val($(this).attr('value'));
        //Limpa os campos aps mudar de aba!!
        $('#empreendimento_estorno').val(null).trigger("change");
        $('.parcelas_paga_estorno').select2('val', '');
        $('#empreendimento_baixa').val('');
        $("#cliente_estorno").val('');
        $("#lote_estorno").val('');
        $("#num_contrato_estorno").val('');
        $("#num_parcela_estorno").val('');
        $("#num_baixa").val('');
        $("#gerar").attr('disabled', false);
    });

    $('#num_baixa').blur(function () {
        $.ajax({
            type: "POST",
            url: "index.php?m=fin&c=estornarParcela&a=exibirTitulos",
            data: "numero=" + $('#num_baixa').val(),
            dataType: "json",
            success: function (response) {
                
                if (response.length > 1) {
                    
                    var select = "<div class='form-group col-sm-6 divParcela'>"+
                                    "<label class='control-label labelParcela'>"+
                                        "Selecione a parcela:<span class='required' style='color:red'>*</span>"+
                                    "</label>"+
                                    "<select class='form-control select2 selectParcela' id='selectParcela'>";
                    var contador = 0;
                    var span = '';
                    for (var i in response) {
                        if (response[i].pago != '0') {
                            select += "<option value='"+response[i].id_parcela_contrato+"'>Contrato: "+response[i].num_contrato+" - Parcela: "+response[i].parcela+
                                        " - Banco: "+response[i].banco+"</option>";
                            span += "<span class='spanDados' id='"+response[i].id_parcela_contrato+"' hidden>"+response[i].empreendimento+"|"+response[i].cliente+"|"+response[i].lote+"|"+response[i].num_contrato+"|"+response[i].parcela+"</span>"
                            $(".mVisualizar").modal();
                            $('input[type="submit"]').removeAttr('disabled');
                        } else {
                            contador++;
                        }
                    }

                    select += "</select></div>";
                    
                    $(select).insertAfter('.num_baixaModal');
                    $(span).insertAfter('.num_baixaModal');
                } else if (!response) {
                    alert('Esse nmero de baixa no existe.');
                    //Feito para apagar os campos caso d erro!
                    $('#empreendimento_baixa').val('');
                    $("#cliente_estorno").val('');
                    $("#lote_estorno").val('');
                    $("#num_contrato_estorno").val('');
                    $("#num_parcela_estorno").val('');
                    //return false  o stop, ou break do php!
                    return false;
                } else if (response.pago == '0') {
                    alert('A parcela ja se encontra aberta.');
                    $('input[type="submit"]').attr('disabled', 'disabled');
                } else {
                    $('input[type="submit"]').removeAttr('disabled');
                }

                if (contador == response.length) {
                    alert('A parcela ja se encontra aberta.');
                    $('input[type="submit"]').attr('disabled', 'disabled');
                } else if (response.length < 2) {
                    $('#empreendimento_baixa').val(" " + response[0].empreendimento);
                    $("#cliente_estorno").val(" " + response[0].cliente);
                    $("#lote_estorno").val(" " + response[0].lote);
                    $("#num_contrato_estorno").val(" " + response[0].num_contrato);
                    $("#num_parcela_estorno").val(" " + response[0].parcela);
                }
            }
        });
    });

    $('.status').on('ifChecked', function (event) {
        $('.empreendimento_estorno').change();
        if(!$('#contrato_parcela_estorno').val()){
            $('.parcelas_paga_estorno').select2('val', '');
        }
    });

    $('[name="selecionaParcela"]').on('click', function () {
        var dados = $("#"+$('#selectParcela').val()).html();
        dados = dados.split("|");

        $('#empreendimento_baixa').val(" " + dados[0]);
        $("#cliente_estorno").val(" " + dados[1]);
        $("#lote_estorno").val(" " + dados[2]);
        $("#num_contrato_estorno").val(" " + dados[3]);
        $("#num_parcela_estorno").val(" " + dados[4]);

        $(".divParcela").remove();
        $(".labelParcela").remove();
        $(".selectParcela").remove();
    });
});

//Funo para change do select2 funcionar mais tranquilamente
function selectChange(select) {
    if (select.hasClass('empreendimento_estorno')) {
        var radio = $("input[name='tipo']:checked").val();

        $("select.contrato_parcela_estorno").val('').trigger('change');
        $("select.contrato_parcela_estorno").prop('disabled', false);
        $.ajax({
            type: "POST",
            url: "index.php?m=fin&c=estornarParcela&a=contratoByEmpreendimento",
            data: {idEmpreendimento: select.val(), tipo: radio},
            success: function (response) {
                $("select.contrato_parcela_estorno").select2({
                    data: JSON.parse(response),
                    placeholder: 'Escolha o Contrato',
                    allowClear: true
                });
            }
        });
    }
    if (select.hasClass('contrato_parcela_estorno')) {
        $("select.parcelas_paga_estorno").html('<option value=""></option>');
        $.ajax({
            type: "POST",
            url: "index.php?m=fin&c=estornarParcela&a=contrato_parcela_paga" + '&tipoParcela=' + $('select.parcelas_paga_estorno:checked').val(),
            data: "contrato=" + select.val() + '&tipoParcela=' + $('.status:checked').val(),
            success: function (response) {
                $("select.parcelas_paga_estorno").attr('disabled', false);
                $("select.parcelas_paga_estorno").select2({
                    data: JSON.parse(response),
                    placeholder: 'Escolha a Parcela',
                    allowClear: true
                });
            }
        });
    }
}