$(document).ready(function () {

    $('[name="campoAssinatura"]').on('ifChecked', function (){
        if ($(this).val() == 'P') {
            $('#divRemetente').hide("slow");
        }
        else {
            $.ajax({
                url: "?m=fin&c=cartaCobranca&a=validarRemetente&emp="+$(".cartaCobrancaEmpreendimento").val(),
                cache: false,
                contentType: false,
                processData: false,
                type: 'POST',
                beforeSend: function () {
                    $('#gerar').disable = true;
                },
                success: function (json) {
                    json = JSON.parse(json);
                    if (json) {
                        $('.msgErros').html(json).show();
                        setTimeout(function () {
                            $('.msgErros').slideUp();
                        }, 5000);
                    } else {
                        $('#divRemetente').show("slow");
                    }
                }
            });
        }
    });

    $('#gerar').on('click', function (e) {

        var $form = $('#form'),
            params = $form.serializeArray(),
            formData = new FormData();

        $.each(params, function (i, val) {
            formData.append(val.name, val.value);
        });
        
        $.ajax({
            url: "?m=fin&c=cartaCobranca&a=validar",
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            type: 'POST',
            beforeSend: function () {
                $('#gerar').disable = true;
            },
            success: function (json) {
                json = JSON.parse(json);
                if (json.msgErros) {
                    $('.msgErros').html(json.msgErros).show();
                    setTimeout(function () {
                        $('.msgErros').slideUp();
                    }, 5000);
                } else
                    $('form').submit();
            }
        })
    });
});
/**
 * Created by programacao-03 on 23/02/16.
 * Alterado by programacao-02 on 11/04/2018.
 */

//Preenche o select de clientes com base no empreendimento selecionado
function selectChange(select) {
    if (select.hasClass('cartaCobrancaEmpreendimento')) {
        $("select.cartaCobrancaClientes").html('<option value="">Selecione ...</option>');
        $.ajax({
            type: "POST",
            url: "index.php?m=fin&c=cartaCobranca&a=contratoByEmpreendimento",
            data: "id_empreendimento=" + select.val(),
            success: function (response) {
                $("select.cartaCobrancaClientes").select2({
                    'data': JSON.parse(response),
                    'placeholder': 'Escolha o Contrato',
                    'allowClear': false
                });

                $("select.cartaCobrancaClientes").attr('disabled', false);
            }
        });
    }

    if (select.hasClass('cartaCobrancaEmpreendimento')) {
        $("select.cartaCobrancaRemetentes").html('<option value="">Selecione ...</option>');
        $.ajax({
            type: "POST",
            url: "index.php?m=fin&c=cartaCobranca&a=remetenteByEmpreedimento",
            data: "id_empreendimento=" + select.val(),
            success: function (response) {
                $("select.cartaCobrancaRemetentes").select2({
                    'data': JSON.parse(response),
                    'placeholder': 'Escolha o Remetente',
                    'allowClear': false
                });

                $("select.cartaCobrancaRemetentes").attr('hidden', false);
                $("select.cartaCobrancaRemetentes").attr('disabled', false);
            }
        });
    }
}
