$(document).ready(function () {

    /**
     * Nova funo para listar!!
     *
     */
    $.when( carregaDados() ).done(function( thisTable ) {
        inputAvanc(thisTable, true)
    });

    function carregaDados() {
        var table = $('#TabelaListar').dataTable({
            "autoWidth": true,
            "ajax": $('#TabelaListar').dataTable.pipeline({
                "url": "index.php?m=fin&c=cartaCobranca&a=listar",
                "pages": 5
            }),
            destroy: true,
            orderCellsTop: true,
            "columns": [
                {"data": 'contrato'},
                {"data": 'empreendimento'},
                {"data": 'quadra'},
                {"data": 'lote'},
                {"data": 'pessoa'},
                {"data": 'termos'},
                {"data": 'acoes'}
            ],
    
            //Define a coluna default que ser ordenada quando abrir a pgina
            "order": [[0, "asc"]],
    
            //Organiza os botoes, paginao, campos e notificaes
            dom: '<"btnGerar"><"btnAdicionar">lfrtip',
    
            //Define as opes de quantidade de linhas que apareco na lista
            "lengthMenu": [[10, 25, 50], [10, 25, 50]],
    
            //Define as colunas que no tero ordenao
            "columnDefs": [
                {
                    "orderable": false,
                    "targets": -1,
                    "searchable": false
                }
            ],
    
            //Pensonalizando as mensagens que por default so em ingls e formatao de valores
            language: {
                "sEmptyTable": "Nenhum registro encontrado",
                "sInfo": "",
                "sInfoEmpty": "",
                "sInfoFiltered": "",
                "sInfoPostFix": "",
                "sInfoThousands": ".",
                "sLengthMenu": "_MENU_",
                "sLoadingRecords": "Carregando...",
                "sProcessing": "Processando...",
                "sZeroRecords": "Nenhum registro encontrado",
                "sSearch": "Busca",
                "oPaginate": {
                    "sNext": "Prximo",
                    "sPrevious": "Anterior",
                    "sFirst": "Primeiro",
                    "sLast": "ltimo"
                },
                "oAria": {
                    "sSortAscending": ": Ordenar colunas de forma ascendente",
                    "sSortDescending": ": Ordenar colunas de forma descendente"
                },
    
                "decimal": ",",
                "thousands": "."
            }
        });
        return table;
    }
    //Boto "Emitir" da listagem de Carta Cobrana
    var btnEnviarVarias = '<a class="btn btn-primary" href="?m=fin&c=cartaCobranca&a=adicionarVarias"><i class="fa fa-plus-circle"></i> Emitir Vrias</a>';

    $("div.btnAdicionar").html(btnEnviarVarias);

    var btnModelTutorial = ' <span data-toggle="modal" data-target=".mVisualizar" style="font-size: 22px;" data-toggle="tooltip" data-placement="top" title="Assista ao tutorial">'+
                            '<svg xmlns="" width="22" height="22" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">'+
                                '<path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z"></path>'+
                            '</svg>'+
                        '</span>';
    
    $("div.dataTables_filter").after(btnModelTutorial);

});

function cartaCobranca(id) {
    var tpcarta = $("#termo_"+id).val();

    if (id != '') {
        for (var i = 1; i <= 3; i++) {
            var link = $('#link_' + id).attr('href');
            var res = link.split('&');
            var oLink = res[0] + '&' + res[1] + '&' + res[2] + '&' + res[3] + '&tpcarta=' + tpcarta;
            $('#link_' + id).attr('href', oLink);
        }
    }
}

function alteraRemetente(id) {
    m = (getUrl('m')?getUrl('m'):'sc');
    $.ajax({
        type: 'POST',
        url: '?m=' + m + '&c=' + getUrl('c') + '&a=alteraRemetente',
        dataType: 'json',
        data: {id: id},
        beforeSend: function () {
            $("#modalVisualizar .modal-body").html('<div align="center">Carregando. . . <a class="loading"></a></div>');
        },
        success: function (data) {
            $('.cartaCobrancaAssinatura').select2({
                'allowClear': false
            }).empty().trigger('change');
            $('.cartaCobrancaRemetentes').select2({
                'allowClear': false
            }).empty().trigger('change');
            $("#contratoId").text(data["detalhes"][0].contratoId);
            $("#empreendimentoNome").text(data["detalhes"][0].empreendimentoNome);
            $("#quadraId").text(data["detalhes"][0].quadra);
            $("#LoteId").text(data["detalhes"][0].lote);
            $("#clienteNome").text(data["detalhes"][0].contratoNome);            
            $.each(data["cartas"], function (i, item) {
                $('.cartaCobrancaTipo').append($('<option>', { 
                    value: item.codModelo,
                    text : item.nomTitulo 
                })).trigger('change');
            });

            $('.classAssinatura').on('ifChecked', function () {
                $(".cartaCobrancaAssinatura").empty().trigger('change');
                if ($(this).val() == 'P') {
                    $(".cartaCobrancaAssinatura").append($('<option>', {
                        value: '',
                        text : 'Proprietrio do Sistema'
                    })).prop('selected', 'selected').trigger('change');
                } 
                else if ($(this).val() == 'E') {
                    $.each(data["remetentes"], function (i, item) {
                        var option = new Option(item.text,item.value,true,true);
                        $(".cartaCobrancaAssinatura").append(option).trigger('change');
                    });
                }
            });
    
            $('.classRemetente').on('ifChecked', function () {
                $(".cartaCobrancaRemetentes").empty().trigger('change');
                if ($(this).val() == 'P') {
                    $(".cartaCobrancaRemetentes").append($('<option>', {
                        value: '',
                        text : 'Proprietrio do Sistema'
                    })).prop('selected', 'selected').trigger('change');
                } 
                else if ($(this).val() == 'E') {
                    $.each(data["remetentes"], function (i, item) {
                        var option = new Option(item.text,item.value,true,true);
                        $(".cartaCobrancaRemetentes").append(option).trigger('change');
                    });
                }
            });
        }
    });
}

$('#doAlteraRemetente').on('click', function (e) {
        var codCartaCobranca = $('#cartaCobrancaTipo option:selected').val();
        var codAssinatura = $('.cartaCobrancaAssinatura option:selected').val();
        var codRemetente = $('.cartaCobrancaRemetentes option:selected').val();
        var codContrato = $('#contratoId').text();
        
        if(codRemetente == undefined || codAssinatura == undefined) {
            alert("Preencha todos os campos!");
        } else  {
            window.open('index.php?m=fin&c=cartaCobranca&a=imprime&id='+ codContrato 
            + '&tpcarta=' + codCartaCobranca + '&codAssinatura=' + codAssinatura +'&codRem=' + codRemetente, '_blank');
        }
});

$('.modalAlteraRemetente').on('hidden.bs.modal', function () {
    $('#formAlteraRemetente .classAssinatura').iCheck('uncheck');
    $('#formAlteraRemetente .classRemetente').iCheck('uncheck');
    $(".form-control-static").text('');
    $('.cartaCobrancaTipo').prop('selectedIndex', 0);
    $('.cartaCobrancaAssinatura').empty().trigger('change');
    $('.cartaCobrancaRemetentes').empty().trigger('change');
});

function hide() {
    $('thead tr').last().toggle('1000');
}

function inputAvanc(table, first) {
    $(document).ready(function () {
        // Busca avanada
        $('#TabelaListar thead tr:eq(1) th').each(function (i) {
            title = $(this).text();
            if (title == 'Empreendimento' || title == 'Quadra' || title == 'Lote' || title == 'Cliente') {
                var search = '<input hide type="text" class="form-control input-sm" style="width:100%" placeholder="' + title + '" />';            
            } else {
                var search = '';
            }
            if (first) {
                $(this).html('');
            }
            // Apply the filter
            $(search).appendTo(this).keyup(function(){table.fnFilter($(this).val(),i)})
        });

        $('thead tr').last().hide();
        $('.dataTables_filter').after('<a href="#" class="btn btn-sm btn-default" onClick="hide()">Busca Avanada</a>');
    });
}