$(document).ready(function () {
    $(".flTipo").on('click', function () {
        $('#flOpcao').val($(this).attr('tipo'));
        //Limpa os campos aps mudar de aba!!
        $('.empreendimento_baixa_parcela').val(null).trigger("change");
        $('.contrato_baixa_parcela').val(null).trigger("change");
        $('.parcelas_baixa').val(null).trigger("change");
        //aba de inativos
        $('.empreendimento_aba_inativos').val(null).trigger("change");
        $('.contrato_aba_inativos').val(null).trigger("change");
        $('.parcela_aba_inativos').val(null).trigger("change");
        //aba de inativos
        $('#nr_parcela').val('');
        $('#empreendimento').val('');
        $("#cliente").val('');
        $("#lote").val('');
        $("#num_contrato").val('');
        $("#num_parcela").val('');
        $("#obs").val('');
        $("#gerar").attr('disabled',false);
        limpaCampos();
    });

    $("#nr_parcela").blur(function () {
        $.ajax({
            type: "POST",
            url: "index.php?m=fin&c=baixaParcela&a=parcelaDados",
            data: "numero=" + $(this).val(),
            dataType: "json",
            success: function (response) {
                if (!response) {
                    alert('Ttulo no encontrado!');
                } else {

                    $("#status").val(response.status);
                    $('#nm_empreendimento').val(response.nm_empreendimento);
                    $('#nm_id_empreendimento').val(response.id_empreendimento);
                    $('#nm_id_contrato').val(response.id_contrato);
                    $("#cliente").val(response.nm_pessoa);
                    $("#lote").val('Quadra ' + response.quadra + ' Lote ' + response.lote);
                    $("#num_contrato").val(response.id_contrato);
                    $("#num_parcela").val(response.id_parcela + response.tp_parcela);

                    if (response.pago == '1') {
                        $('input[type="submit"]').attr('disabled', 'disabled');
                        $("#gerar").attr('disabled', true);
                        alert('Parcela j baixada.');
                    } else {
                        $('input[type="submit"]').removeAttr('disabled');
                        $("#Desconto").val(float2moeda(response.desconto));

                        $.ajax({
                            type: "POST",
                            url: "index.php?m=fin&c=baixaParcela&a=bancoEmpreendimento",
                            data: "id_empreendimento=" + response.id_empreendimento,
                            success: function (response) {
                                $("select.banco").select2({
                                    data: JSON.parse(response)
                                });
                            }
                        });
                    }
                }
            }
        });
        $.ajax({
            type: "POST",
            url: "index.php?m=fin&c=baixaParcela&a=calculaValorTotal",
            data: {
                numero: $(this).val(),
                dataPagamento: $('#dt_pagamento').val()
            },
            dataType: "json",
            success: function (response) {
                $("#multa").val(float2moeda(response.multa));
                $("#juros").val(float2moeda(response.juros));
                $("#data_vencimento").val(response.dt_vencimento);
                $("#valor_do_titulo").val(float2moeda(response.valor));
                $("#valor_acrescimo").val(float2moeda(response.acrescimo));
                $("#total_baixa_parcela").val(float2moeda(response.total));
            }
        });
    });
    $("#multa,#juros,#Desconto").blur(function () {
        $("#total_baixa_parcela").val(calcularValores());
    });

    $("#btnRecalcula").click(function () {
        var numeroParcela;
        if ($('#flOpcao').val() == 'N') {
            numeroParcela = $('#nr_parcela').val();
        } else if ($('#flOpcao').val() == 'B') {
            numeroParcela = $('#id_parcela').val();
        }
        if (numeroParcela) {

            $.ajax({
                type: "POST",
                url: "index.php?m=fin&c=baixaParcela&a=calculaValorTotal",
                data: {
                    numero: numeroParcela,
                    dataPagamento: $('#dt_pagamento').val()
                },
                dataType: "json",
                success: function (response) {
                    $("#Desconto").val(float2moeda(response.desconto));
                    $("#multa").val(float2moeda(response.multa));
                    $("#juros").val(float2moeda(response.juros));
                    $("#data_vencimento").val(response.dt_vencimento);
                    $("#valor_do_titulo").val(float2moeda(response.valor));
                    $("#valor_acrescimo").val(float2moeda(response.acrescimo));
                    $("#total_baixa_parcela").val(float2moeda(response.total));
                }
            });
        }

    });
    // Ao criada para no fazer um submit, mas sim um verificar completamente por AJAX.
    $('#gerar').on('click', function (e) {

        var $form = $('#form'),
            params = $form.serializeArray(),
            formData = new FormData();

        $.each(params, function (i, val) {
            formData.append(val.name, val.value);
        });

        $.ajax({
            url: "index.php?m=fin&c=baixaParcela&a=index",
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            type: 'POST',
            beforeSend: function () {
                $('#gerar').disable = true;
            },
            success: function (json) {
                json = JSON.parse(json);

                if (json.msgErros != '') {
                    $('.msgErros').html(json.msgErros).show();
                    setTimeout(function () {
                        $('.msgErros').slideUp();
                    }, 5000);
                } else if (json.msgSucess) {
                    $('.msgSucess').html('Baixa realizada com sucesso').show();
                    setTimeout(function () {
                        $('.msgSucess').slideUp();
                    }, 5000);
                    $('#id_contrato').val($('#id_contrato').val()).trigger('change');
                    limpaCampos();
                    //Adicionado campo para solicitar gerao de recibo
                    if (json.idRecibo != '')
                        window.open('?m=fin&c=recibo&a=gerar&id=' + json.idRecibo, '_blank');
                }
            }
        })
    })
});

//Funo para change do select2 funcionar mais tranquilamente
function selectChange(select) {
    
    if (select.hasClass('empreendimento_baixa_parcela')) {
        
        if (select.val()) {
            
            $("select.contrato_baixa_parcela").html('<option value=""></option>').trigger('change');
            $("select.parcelas_baixa").html('<option value=""></option>').trigger('change');
            
            $.ajax({
                type: "POST",
                url: "index.php?m=fin&c=baixaParcela&a=contratoAtivoEmpreendimento",
                data: "id_empreendimento=" + select.val(),
                success: function (response) {
                    $("select.contrato_baixa_parcela").select2({
                        data: JSON.parse(response)
                    });
                }
            });

            $.ajax({
                type: "POST",
                url: "index.php?m=fin&c=baixaParcela&a=bancoEmpreendimento",
                data: "id_empreendimento=" + select.val(),
                success: function (response) {
                    var json = JSON.parse(response);
                    if (json) {
                        $("select.banco").html('');
                        $("select.banco").select2({
                            'data': json,
                            'placeholder': 'Escolha o Banco',
                            'allowClear': true,
                            'language': {
                                "noResults": function () {
                                    return "Nenhum resultado encontrado";
                                },
                                "searching": function () {
                                    return "Pesquisando...";
                                }
                            }
                        });
                    }
                }
            });
        }
    }
    if (select.hasClass('contrato_baixa_parcela')) {
        $("select.parcelas_baixa").html('<option value=""></option>').trigger('change');
        if (select.val() !== '')
            $.ajax({
                type: "POST",
                url: "index.php?m=fin&c=baixaParcela&a=parcelaNPagaContrato",
                data: "contrato=" + select.val(),
                success: function (response) {
                    $("select.parcelas_baixa").select2({
                        data: JSON.parse(response)
                    });
                }
            });
    }
    if (select.hasClass('parcelas_baixa')) {
        $.ajax({
            type: "POST",
            url: "index.php?m=fin&c=baixaParcela&a=calculaValorTotal",
            data: {
                numero: select.val(),
                dataPagamento: $('#dt_pagamento').val()
            },
            dataType: "json",
            success: function (response) {
                $("#Desconto").val(float2moeda(response.desconto));
                $("#multa").val(float2moeda(response.multa));
                $("#juros").val(float2moeda(response.juros));
                $("#data_vencimento").val(response.dt_vencimento);
                $("#valor_do_titulo").val(float2moeda(response.valor));
                $("#valor_acrescimo").val(float2moeda(response.acrescimo));
                $("#total_baixa_parcela").val(float2moeda(response.total));
            }
        });
    }

    if (select.hasClass('empreendimento_aba_inativos'))
    {
        if (select.val())
        {
            $('select.contrato_aba_inativos').html('<option value=""></option>').trigger('change');
            $('select.parcela_aba_inativos').html('<option value=""></option>').trigger('change');

            $.ajax({
                type: "POST",
                url: "index.php?m=fin&c=baixaParcela&a=contratoAtivoEmpreendimento",
                data: "id_empreendimento_aba_inativos=" + select.val(),
                success: function (response)
                {
                    $("select.contrato_aba_inativos").select2({
                        data: JSON.parse(response)
                    });
                }
            });

            $.ajax({
                type: "POST",
                url: "index.php?m=fin&c=baixaParcela&a=bancoEmpreendimento",
                data: "id_empreendimento_aba_inativos=" + select.val(),
                success: function (response) {
                    var json = JSON.parse(response);
                    if (json) {
                        $("select.banco").html('');
                        $("select.banco").select2({
                            'data': json,
                            'placeholder': 'Escolha o Banco',
                            'allowClear': true,
                            'language': {
                                "noResults": function () {
                                    return "Nenhum resultado encontrado";
                                },
                                "searching": function () {
                                    return "Pesquisando...";
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    if (select.hasClass('contrato_aba_inativos')) {
        $("select.parcela_aba_inativos").html('<option value=""></option>').trigger('change');
        if (select.val() !== '')
            $.ajax({
                type: "POST",
                url: "index.php?m=fin&c=baixaParcela&a=parcelaNPagaContrato",
                data: "contratoInativo=" + select.val(),
                success: function (response) {
                    $("select.parcela_aba_inativos").select2({
                        data: JSON.parse(response)
                    });
                }
            });
    }

    if (select.hasClass('parcela_aba_inativos')) {
        $.ajax({
            type: "POST",
            url: "index.php?m=fin&c=baixaParcela&a=calculaValorTotal",
            data: {
                numeroAbaInativos: select.val(),
                dataPagamento: $('#dt_pagamento').val()
            },
            dataType: "json",
            success: function (response) {
                $("#Desconto").val(float2moeda(response.desconto));
                $("#multa").val(float2moeda(response.multa));
                $("#juros").val(float2moeda(response.juros));
                $("#data_vencimento").val(response.dt_vencimento);
                $("#valor_do_titulo").val(float2moeda(response.valor));
                $("#valor_acrescimo").val(float2moeda(response.acrescimo));
                $("#total_baixa_parcela").val(float2moeda(response.total));
            }
        });
    }
}

//Funo limpa campos retirada da view, para melhor organizao
function limpaCampos() {
    var dtIni = dataFormatada(),
        dtFin = dataFormatada();
    $("#Desconto").val(null);
    $("#multa").val(null);
    $("#juros").val(null);
    $("#data_vencimento").val(null);
    $("#valor_do_titulo").val(null);
    $("#valor_acrescimo").val(null);
    $("#total_baixa_parcela").val(null);
    $("#dt_credito").val(dtIni);
    $("#dt_pagamento").val(dtFin);
    $('#tipoBaixa').val(null).trigger('change');
    $('#banco').val(null).trigger('change');
    $('#formaBaixa').val(null).trigger('change');
}

function calcularValores() {
    var titulo = moeda2float($("#valor_do_titulo").val()),
        multa = moeda2float($("#multa").val()),
        juros = moeda2float($("#juros").val()),
        desconto = moeda2float($("#Desconto").val()),
        acrescimo = moeda2float($('#valor_acrescimo').val());
    return float2moeda((titulo + multa + juros + acrescimo) - desconto);
}

//Funo para pegar data do servidor
function dataFormatada() {
    var data = new Date(),
        dia = data.getDate(),
        mes = data.getMonth() + 1,
        ano = data.getFullYear();
    return [dia, mes, ano].join('/');
}