$(document).ready(function () {

    //autocomplete utilizando o plugin select2
    select2RemoteData(
        '#idPessoaJuridica',
        false,
        true,
        'Digite o nome, cpf ou cnpj do Representante',
        '?m=contabil&c=dadosContabeis&a=findPessoasByNome'
    );

    //autocomplete utilizando o plugin select2
    select2RemoteData(
        '#idContador',
        false,
        true,
        'Digite o nome ou cpf do Contador',
        '?m=contabil&c=dadosContabeis&a=findPessoaFisicaByNome'
    );

    //autocomplete utilizando o plugin select2
    select2RemoteData(
        '#idContabilidade',
        false,
        true,
        'Digite o nome ou cnpj da Contabilidade',
        '?m=contabil&c=dadosContabeis&a=findPessoaJuridicaByNome'
    );

    $('.gerar').on('click', function (e) {
        var $form = $('#form'),
            params = $form.serializeArray(),
            formData = new FormData();
        $.each(params, function (i, val) {
            formData.append(val.name, val.value);
        });
        $.ajax({
            url: "?m=contabil&c=dadosContabeis&a=validar",
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            type: 'POST',
            success: function (json) {
                json = JSON.parse(json);
                if (json.msgErros) {
                    $('.msgErros').html(json.msgErros).show();
                    setTimeout(function () {
                        $('.msgErros').slideUp();
                    }, 5000);
                } else {
                    $('form').submit();
                }
            }
        })
    });

    $('#vlPorcDeclarada').on('blur', function() {
        var porcTotal = parseFloat($('#hiddenVlTotalPorcDeclarada').val()),
            porcRestante = 100 - porcTotal,
            porcCampo = moeda2float($(this).val());

        if (porcCampo > 100) {
            alert('A porcentagem no pode ser maior que 100%');
            $(this).val(float2moeda(porcRestante));
        } else if (porcRestante == 0 && porcCampo > porcRestante) {
            alert('A soma de todas porcentagens para este empreendimento j deu 100%');
            $(this).val('0,00');
        } else if (porcCampo > porcRestante && porcRestante != 0) {
            alert('Ja esta sendo utilizado '+porcTotal+'%, resta apenas '+porcRestante+'%');
            $(this).val(porcRestante);
        }
    });
});

//Funo para change do select2 funcionar mais tranquilamente
function selectChange(select) {
    if (select.hasClass('empreendimentoSped')) {
        $.ajax({
            type: "POST",
            url: "index.php?m=contabil&c=dadosContabeis&a=findPorcentagemDeclarada",
            data: "idEmpreendimento=" + select.val(),
            success: function (response) {
                var vlPorcDeclarada = parseFloat(JSON.parse(response));
                $('#spanPorcDeclarada').show();
                $('#spanValorPorcDeclarada').html(float2moeda(vlPorcDeclarada)+'%');
                $('#hiddenVlTotalPorcDeclarada').val(vlPorcDeclarada);
                $('#vlPorcDeclarada').attr('disabled', false);

                if(vlPorcDeclarada > 0 && vlPorcDeclarada < 100) {
                    $('#vlPorcDeclarada').val(float2moeda(100 - vlPorcDeclarada));
                } else {
                    $('#vlPorcDeclarada').val('0,00');
                }
            }
        });
    }
    if (select.hasClass('idPessoaJuridica')) {
        var hiddenIdContador = $('#hiddenIdContador').val(),
            hiddenIdPessoaJuridica = $('#hiddenIdPessoaJuridica').val();
        if (hiddenIdPessoaJuridica != select.val() && hiddenIdContador != $('#idContador').val()) {
            $.ajax({
                type: "POST",
                url: "index.php?m=contabil&c=dadosContabeis&a=findPjResponsavelCorretor",
                data: "idRespJuridico=" + select.val()+'&idEmpreendimento='+$('#empreendimento').val()+'&idContador='+$('#idContador').val(),
                success: function (response) {
                    var existeDadosIguais = parseFloat(JSON.parse(response));

                    if(existeDadosIguais == 1) {
                        alert('Ja existe um empreendimento cadastrado com esse Responsvel Juridico e Contador');
                        $('#idContador').val(hiddenIdContador).trigger('change');
                        $('#idPessoaJuridica').val(hiddenIdPessoaJuridica).trigger('change');
                    }
                }
            });
        }
    }
    if (select.hasClass('idContador')) {
        var hiddenIdContador = $('#hiddenIdContador').val(),
            hiddenIdPessoaJuridica = $('#hiddenIdPessoaJuridica').val();

        if (hiddenIdPessoaJuridica != $('#idPessoaJuridica').val() && hiddenIdContador != select.val()) {
            $.ajax({
                type: "POST",
                url: "index.php?m=contabil&c=dadosContabeis&a=findPjResponsavelCorretor",
                data: "idContador=" + select.val()+'&idEmpreendimento='+$('#empreendimento').val()+'&idRespJuridico='+$('#idPessoaJuridica').val(),
                success: function (response) {
                    var existeDadosIguais = parseFloat(JSON.parse(response));

                    if(existeDadosIguais == 1) {
                        alert('Ja existe um empreendimento cadastrado com esse Responsvel Juridico e Contador');
                        $('#idContador').val(hiddenIdContador).trigger('change');
                        $('#idPessoaJuridica').val(hiddenIdPessoaJuridica).trigger('change');
                    }
                }
            });
        }
    }
}
