$(document).ready(function () {
    //Boto "Gerar"
    $('.gerar').on('click', function (e) {
        if ($(this).attr('id') == 'gerarArquivo') {
            if(confirm('Voc realmente deseja gerar o arquivo SPED?')) {
                $('#gerarRelatorio').val(0);
                $('form').attr('target','');
                gerar($(this));
            }
        } else {
            $('#gerarRelatorio').val(1);
            $('form').attr('target','_blank');
            gerar($(this));
        }
    });
    //Campo "Gerar Por"
    $('[name="tipoGeracao"]').on('ifChecked', function () {
        $('#divPorcRelatorio').hide('slow');
        $('#divEmpreendimento').hide('slow');
        $('#divRespJuridico').show('slow');
        $('#divGerar').hide('slow');
        if ($(this).val() == 'E') {
            $('#divEmpreendimento').show('slow');
            $('#divPorcRelatorio').show('slow');
            $('#divRespJuridico').hide('slow');
            $('#divGerar').show('slow');
            $('#tipoImpressao').show('slow');
        } else {
            $('#tipoImpressao').hide('slow');
            $('#empreendimento').val(null).trigger("change");
        }
    });
});

function gerar() {
    var $form = $('#form'),
        params = $form.serializeArray(),
        formData = new FormData();
    $.each(params, function (i, val) {
        formData.append(val.name, val.value);
    });
    $.ajax({
        url: "?m=contabil&c=arquivoSped&a=validar",
        data: formData,
        cache: false,
        contentType: false,
        processData: false,
        type: 'POST',
        success: function (json) {
            json = JSON.parse(json);
            if (json.msgErros) {
                $('.msgErros').html(json.msgErros).show();
                setTimeout(function () {
                    $('.msgErros').slideUp();
                }, 5000);
            } else {
                $('form').submit();
            }
        }
    })
}
