$(document).ready(function () {
    $('#TabelaListar').DataTable({
        "processing": true,
        "serverSide": true,
        "autoWidth" : true,
        "ajax" : $('#TabelaListar').dataTable.pipeline({
            "url" : "index.php?m=contabil&c=arquivoDimob&a=listar",
            "pages" : 5
        }),
        "columns" : [
            {"data" : "idDimob"},
            {"data" : "nmEmpreendimento"},
            {"data" : "dtGeracao"},
            {"data" : "anoContrato"},
            {"data" : "anoRecebimento"},
            {"data" : "sinal"},
            {"data" : "dsArquivo"},
            {"data" : "acoes"}
        ],

        //Define a coluna default que ser ordenada quando abrir a pgina
        "order" : [[0, "desc"]],

        //Organiza os botes, paginao, campos e notificaes
        dom : '<"btnAdicionar">lfrtip',

        //Define as colunas que no tero ordenao
        "columnDefs" : [
            {
                "orderable" : false,
                "targets" : -1,
                "searchable" : false
            }
        ],

        //Personalizando as mensagens que por default so em ingls e formatao de valores
        language : {
            "sEmptyTable" : "Nenhum registro encontrado",
            "sInfo" : "",
            "sInfoEmpty" : "",
            "sInfoFiltered" : "",
            "sInfoPostFix" : "",
            "sInfoThousands" : ".",
            "sLengthMenu" : "_MENU_",
            "sLoadingRecords" : "Carregando...",
            "sProcessing" : "Processando...",
            "sZeroRecords" : "Nenhum registro encontrado",
            "sSearch" : "Busca",
            "oPaginate" : {
                "sNext" : "Prximo",
                "sPrevious" : "Anterior",
                "sFirst" : "Primeiro",
                "sLast" : "ltimo"
            },
            "oAria" : {
                "sSortAscending" : ": Ordenar colunas de forma ascendente",
                "sSortDescending" : ": Ordenar colunas de forma descendente"
            },

            "decimal" : ",",
            "thousands" : "."
        }
    });
});