$(document).ready(function () {
    $('#tabelaListar').DataTable({
        ajax: '?m=comunicacao&c=cadastroEmail&a=getLista',
        columns: [
            { data: "id" },
            { data: "setor" },
            { data: "email" },
            {
                data: "id",
                render: function (data) {
                    var edit = `<a href="?m=comunicacao&c=cadastroEmail&a=editar&id=${data}" data-toggle="tooltip" title="" class="btn btn-default btn-sm"` +
                        `style="margin-right:5px" data-original-title="EDITAR"><i class="fa fa-edit"></i></a>`;
                    var del = `<a onclick="return confirm('Deseja realmente deletar?')" href="?m=comunicacao&c=cadastroEmail&a=deletar&id=${data}"` +
                        `data-toggle="tooltip" title="" class="btn btn-default btn-sm" style="margin-right:5px" data-original-title="DELETAR">` +
                        `<i class="fa fa-times"></i></a>`;
                    return edit + del;
                }
            }
        ],
        //Define a coluna default que ser ordenada quando abrir a pgina
        order: [[0, "desc"]],

        //Organiza os botes, paginao, campos e notificaes
        dom: '<"btnAdicionar">lfrtip',

        //Personalizando as mensagens que por default so em ingls e formatao de valores
        language: {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "",
            "sInfoEmpty": "",
            "sInfoFiltered": "",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Busca",
            "oPaginate": {
                "sNext": "Prximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "ltimo"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            },

            "decimal": ",",
            "thousands": "."
        }
    });
});