var table;
$(document).ready(function () {
    atualizarDados();
});
function hide() {
    $('thead tr').last().toggle('1000');
}

function atualizarDados(){
    $.when( carregaDados() ).done(function( thisTable ) {
        inputAvanc(thisTable, true);
        $('.dataTables_filter').after(`
            <div class="form-group col-sm-2" style="width: auto;float:right;">
                <input type="button" class="btn btn-success fDesabilitaBtn" id="btEnviar" onclick="enviarSelecionados(this)" value="Enviar selecionados" data-original-title="" title="">
            </div>
            <div class="form-group col-sm-2" style="width: auto;float:right;">
                <input type="button" class="btn btn-danger fDesabilitaBtn" id="btApagar" onclick="deletarSelecionados(this)" value="Apagar selecionados" data-original-title="" title="">
            </div>
        `);
    });
}
function carregaDados(){
    table = $('#tabelaListar').DataTable({
        ajax: '?m=comunicacao&c=agendamento&a=getLista&tipo='+$("#tipo").val(),
        responsive: true,
        processing: true,
        serverSide: true,
        destroy: true,
        orderCellsTop: true,
        lengthMenu: [[10, 25, 50, 100], [10, 25, 50,100]],
        columns: [
            {
                data: "status",
                orderable: false,
                render: function (data) {
                    return `<input type="checkbox" id="agendamento${data.id}" name="agendamento" value="${data.id}" ${data.status=="Enviado"?"disabled":""}>`
                }
            },
            { data: "tipo" },
            { data: "idContrato" },
            { data: "nomeDestinatario" },
            { data: "empreendimento" },
            { data: "id_parcela" },
            { data: "dataAgendado" },
            { data: "dataEnviado" },
            { data: "cliente",
                render: function (data) {
                    if(data.includes("@")){
                        return "E-mail";
                    }            
                    return "WhatsApp";
                }
            },
            { data: "cliente" },
            {
                data: "status",
                render: function (data) {
                    var classe;
                    if (data.status == 'Agendado') {
                        classe = 'label-warning';
                    } else if (data.status == 'Enviado') {
                        classe = 'label-success';
                    } else if (data.status == 'No Enviado' || data.status=='Falha ao enviar') {
                        classe = 'label-danger';
                    }
                    return `<span class="label ${classe} status${data.id}">${data.status}</span>`
                }
            },
            {
                data: "status",
                render: function (data) {
                    if(isNaN(data.id)){
                        visualizar = `<span onclick="emailsAgendamento('${data.id}')"><button type="button" ` + 
                        `title="VISUALIZAR" style="margin-right:5px"` +
                        `class="btn btn-default btn-sm btn-agendamentos">` + 
                        `<i class="fa fa-eye"></i></button></span>`;
                        return visualizar;
                    }
                    edit = `<a href="?m=comunicacao&c=agendamento&a=editar&id=${data.id}" data-toggle="tooltip" title="" class="btn btn-default btn-sm"` +
                        `style="margin-right:5px" data-original-title="EDITAR"><i class="fa fa-edit"></i></a>`;
                    del = `<a href="#"` +
                        `data-toggle="tooltip" title="" onClick="deletarEmail(${data.id})" class="btn btn-default btn-sm" data-original-title="DELETAR">` +
                        `<i class="fa fa-times"></i></a>`;
                    add = `<a href="#"` +
                        `data-toggle="tooltip" title=""  class="btn btn-default btn-sm" style="margin-right:5px" data-original-title="ENVIAR AGORA" ${data.status=="Enviado"?" disabled":' onClick="enviarEmail('+data.id+')"'}>` +
                        `<i class="fa fa-upload"></i></a>`;
                    visualizar = `<span data-toggle="modal" data-target=".modalVisualizar"><button type="button" value="${data.id}"` + 
                        `data-toggle="tooltip" title="VISUALIZAR" style="margin-right:5px"` +
                        `class="btn btn-default btn-sm btn-visualizar">` + 
                        `<i class="fa fa-eye"></i></button></span>`;
                    return visualizar + add + del;
                }
            }
        ],
        //Define a coluna default que ser ordenada quando abrir a pgina
        order: [],

        //Organiza os botes, paginao, campos e notificaes
        //dom: '<"btnAdicionar">lfrtip',
        dom: 'Blfrtip',
        buttons: [
            {
                text: 'My button',
                action: function ( e, dt, node, config ) {
                    alert( 'Button activated' );
                }
            }
        ],
        //Personalizando as mensagens que por default so em ingls e formatao de valores
        language: {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "",
            "sInfoEmpty": "",
            "sInfoFiltered": "",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Busca",
            "oPaginate": {
                "sNext": "Prximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "ltimo"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            },

            "decimal": ",",
            "thousands": "."
        }
    });

    var btnModelTutorial = ' <span data-toggle="modal" data-target=".mVisualizar" style="font-size: 22px;" data-toggle="tooltip" data-placement="top" title="Assista ao tutorial">'+
                            '<svg xmlns="" width="22" height="22" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">'+
                                '<path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z"></path>'+
                            '</svg>'+
                        '</span>';
    
    $("div.dataTables_filter").after(btnModelTutorial);
    
    return table;
}
function enviarEmail(id) {
    $('.status'+id)[0].innerHTML = "Enviando";
    $.ajax({
        type: "POST",
        url: "?m=comunicacao&c=agendamento&a=email",
        data: "id=" + id,
        success: function (response) {
            $('.status'+id).removeClass('label-success');
            $('.status'+id).removeClass('label-warning');
            $('.status'+id).removeClass('label-danger');
            if(response!="E-mail enviado com sucesso!"&&response!="WhatsApp enviado com sucesso!"){
                $('.status'+id).addClass('label-danger');
                $('.status'+id)[0].innerHTML = "No Enviado";
                alert(response);
            }
            else if(response=="Agendamento adicionado na lista de envio do whatsapp"){
                
                $('.status'+id).addClass('label-success');
                $('.status'+id)[0].innerHTML = "Agendado";
            }
            else{
                $('.status'+id).addClass('label-success');
                $('.status'+id)[0].innerHTML = "Enviado";
            }
        }
    });
}
function deletarEmail(id) {
    $('.status'+id)[0].innerHTML = "Apagando";
    $.ajax({
        type: "POST",
        url: "?m=comunicacao&c=agendamento&a=deletar",
        data: "id=" + id,
        success: function (response) {
            $('.status'+id).removeClass('label-success');
            $('.status'+id).removeClass('label-warning');
            $('.status'+id).removeClass('label-danger');
            $('.status'+id).addClass('label-danger');
            if(response=="Successo"){
                $('.status'+id)[0].innerHTML = "Excludo";
            }
            else{
                $('.status'+id)[0].innerHTML = "Falha ao excluir";
            }
        }
    });
}
function selectCheckbox(e){
    agendamento=$('input[name=agendamento]');
    for(i=0;i<agendamento.length;i++){
        if(!agendamento[i].disabled){
            agendamento[i].checked=e.checked;
        }
    }
}
function enviarSelecionados(e){
    agendamento=$('input[name=agendamento]');
    for(i=0;i<agendamento.length;i++){
        if(agendamento[i].checked){
            enviarEmail(agendamento[i].value);
        }
    }
}
function deletarSelecionados(e){
    agendamento=$('input[name=agendamento]');
    for(i=0;i<agendamento.length;i++){
        if(agendamento[i].checked){
            deletarEmail(agendamento[i].value);
        }
    }
}
function listaClientes(e){
    $('#tabelaListar').DataTable().search("Clientes").draw();
}
function emailsAgendamento(email){
    $('#tabelaListar').DataTable().search(email).draw();
}
function inputAvanc(table, first) {
    $(document).ready(function () {
        // Busca avanada
        $('#tabelaListar > thead > tr:nth-child(2) >th').each(function (i) {
            title = $(this).text();
            console.log(title);
            if (title == 'Empreendimento' || title == 'Contrato' || title == 'Contato') {
                var search = '<input hide type="text" class="pesquisaAvancada form-control input-sm" style="width:100%" name="' + title.split(" ")[0].replace("-","") + '" placeholder="' + title + '" />';            
            } 
            else if(title == 'Agendado'){
                var search = '<input hide type="text" class="pesquisaAvancada form-control input-sm" style="width:100%" name="Agendado" placeholder="' + title + '" />';            
            }
            else if(title == 'Nome'){
                var search = '<input hide type="text" class="pesquisaAvancada form-control input-sm" style="width:100%" name="Nome" placeholder="' + title + '" />';            
            }
            else if(title == 'Status'){
                var search = '<select hide class="pesquisaAvancada form-control input-sm" style="width:100%" name="' + title + '" placeholder="' + title + '" ><option value="">Tudo</option><option>Agendado</option><option>Enviado</option></select>';            
            }
            else if(title == 'Local'){
                var search = '<select hide class="pesquisaAvancada form-control input-sm" style="width:100%" name="' + title + '" placeholder="' + title + '" ><option value="">Tudo</option><option>WhatsApp</option><option>E-mail</option></select>';            
            }
            else {
                var search = '';
            }
            if (first) {
                $(this).html('');
            }
            // Apply the filter
            $(search).appendTo(this).on('change',function(){
                $("#tabelaListar_filter > label > input").val("");
                var filtro = "";
                for(var i = 0; i < $(".pesquisaAvancada").length;i++){
                    if($(".pesquisaAvancada")[i].value){
                        filtro+=$(".pesquisaAvancada")[i].name+":" +$(".pesquisaAvancada")[i].value+";";
                    }
                }
                table.search(filtro).draw();
            });
        });

        $('thead tr').last().hide();
        $('.dataTables_filter').after('<a href="#" class="btn btn-sm btn-default" onClick="hide()">Busca Avanada</a>');
    });
}
function filtroTipo(){
    table.ajax.url('?m=comunicacao&c=agendamento&a=getLista&tipo='+$("#tipo").val());
    table.ajax.reload();
}